package com.ejianc.business.assist.store.api;

import com.ejianc.business.assist.store.hystrix.AccountSettleHystrix;
import com.ejianc.business.assist.store.hystrix.AmAllotHystrix;
import com.ejianc.business.assist.store.vo.AllotInVO;
import com.ejianc.business.assist.store.vo.AllotOutVO;
import com.ejianc.business.assist.store.vo.StoreApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


@FeignClient(
        name = "ejc-assistrmat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-assistrmat-web",
        fallback = AmAllotHystrix.class)
public interface IAmAllotApi {

    @PostMapping("/api/amAllot/amCreateAllotIn")
    CommonResponse<String> amCreateAllotIn(@RequestBody AllotOutVO allotOutVO);

    @PostMapping("/api/amAllot/amSureToReceive")
    CommonResponse<String> amSureToReceive(@RequestBody AllotInVO allotInVO);

    @PostMapping("/api/amAllot/amSureToReturn")
    CommonResponse<String> amSureToReturn(@RequestBody AllotInVO allotInVO);

}
