package com.ejianc.business.outrmat.proxy.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.outrmat.proxy.vo.ProxyContractDetailVO;

/**
 * 辅料中心-周转材租出-合同授权委托书
 * 
 * @author generator
 * 
 */
@ApiModel("辅料中心-周转材租出-合同授权委托书")
public class ProxyContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("委托编码")
    private String billCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("")
    private String parentOrgName;
    @ApiModelProperty("被委托方组织id")
    private Long proxyOrgId;
    @ApiModelProperty("")
    private String proxyOrgName;
    @ApiModelProperty("被委托方组织编码")
    private String proxyOrgCode;
    @ApiModelProperty("被委托方父级组织")
    private Long proxyParentOrgId;
    @ApiModelProperty("被委托方父级组织编码")
    private String proxyParentOrgCode;
    @ApiModelProperty("")
    private String proxyParentOrgName;
    @ApiModelProperty("委托代理人id")
    private Long proxyEmployeeId;
    @ApiModelProperty("委托代理人名称")
    private String proxyEmployeeName;
    @ApiModelProperty("代理人身份证号")
    private String proxyIdCard;
    @ApiModelProperty("代理人性别(1-男，2-女)")
    private Integer proxySex;
    @ApiModelProperty("办理人")
    private Long employeeId;
    @ApiModelProperty("办理人名称")
    private String employeeName;
    @ApiModelProperty("经办人部门id")
    private Long deptId;
    @ApiModelProperty("经办人部门")
    private String deptName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("办理日期")
    private Date proxyDate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    private String billStateName;
    @ApiModelProperty("合同签订状态：1-未签订，2-已签订")
    private Integer signStatus;
    private String signStatusName;
    @ApiModelProperty("辅料中心-周转材租出-委托书明细")
    private List<ProxyContractDetailVO> proxyContractDetailList = new ArrayList<>();
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    /**
     * 委托编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 委托编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 被委托方组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getProxyOrgId() {
        return proxyOrgId;
    }

    /**
     * 被委托方组织id
     */
    @ReferDeserialTransfer
    public void setProxyOrgId(Long proxyOrgId) {
        this.proxyOrgId = proxyOrgId;
    }
    /**
     * 
     */
    public String getProxyOrgName() {
        return proxyOrgName;
    }

    /**
     * 
     */
    public void setProxyOrgName(String proxyOrgName) {
        this.proxyOrgName = proxyOrgName;
    }
    /**
     * 被委托方组织编码
     */
    public String getProxyOrgCode() {
        return proxyOrgCode;
    }

    /**
     * 被委托方组织编码
     */
    public void setProxyOrgCode(String proxyOrgCode) {
        this.proxyOrgCode = proxyOrgCode;
    }
    /**
     * 被委托方父级组织
     */
    public Long getProxyParentOrgId() {
        return proxyParentOrgId;
    }

    /**
     * 被委托方父级组织
     */
    public void setProxyParentOrgId(Long proxyParentOrgId) {
        this.proxyParentOrgId = proxyParentOrgId;
    }
    /**
     * 被委托方父级组织编码
     */
    public String getProxyParentOrgCode() {
        return proxyParentOrgCode;
    }

    /**
     * 被委托方父级组织编码
     */
    public void setProxyParentOrgCode(String proxyParentOrgCode) {
        this.proxyParentOrgCode = proxyParentOrgCode;
    }
    /**
     * 
     */
    public String getProxyParentOrgName() {
        return proxyParentOrgName;
    }

    /**
     * 
     */
    public void setProxyParentOrgName(String proxyParentOrgName) {
        this.proxyParentOrgName = proxyParentOrgName;
    }
    /**
     * 委托代理人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProxyEmployeeId() {
        return proxyEmployeeId;
    }

    /**
     * 委托代理人id
     */
    @ReferDeserialTransfer
    public void setProxyEmployeeId(Long proxyEmployeeId) {
        this.proxyEmployeeId = proxyEmployeeId;
    }
    /**
     * 委托代理人名称
     */
    public String getProxyEmployeeName() {
        return proxyEmployeeName;
    }

    /**
     * 委托代理人名称
     */
    public void setProxyEmployeeName(String proxyEmployeeName) {
        this.proxyEmployeeName = proxyEmployeeName;
    }
    /**
     * 代理人身份证号
     */
    public String getProxyIdCard() {
        return proxyIdCard;
    }

    /**
     * 代理人身份证号
     */
    public void setProxyIdCard(String proxyIdCard) {
        this.proxyIdCard = proxyIdCard;
    }
    /**
     * 代理人性别(1-男，2-女)
     */
    public Integer getProxySex() {
        return proxySex;
    }

    /**
     * 代理人性别(1-男，2-女)
     */
    public void setProxySex(Integer proxySex) {
        this.proxySex = proxySex;
    }
    /**
     * 办理人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 办理人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 办理人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 办理人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 办理日期
     */
    public Date getProxyDate() {
        return proxyDate;
    }

    /**
     * 办理日期
     */
    public void setProxyDate(Date proxyDate) {
        this.proxyDate = proxyDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同签订状态：1-未签订，2-已签订
     */
    public Integer getSignStatus() {
        return signStatus;
    }

    /**
     * 合同签订状态：1-未签订，2-已签订
     */
    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    
     /**
      * 辅料中心-周转材租出-委托书明细
      */
      public List<ProxyContractDetailVO> getProxyContractDetailList() {
         return proxyContractDetailList;
      }
     /**
      * 辅料中心-周转材租出-委托书明细
      */
     public void setProxyContractDetailList(List<ProxyContractDetailVO> proxyContractDetailList) {
         this.proxyContractDetailList = proxyContractDetailList;
     }
}
