package com.ejianc.business.outrmat.restitute.vo;

import com.ejianc.business.assist.rmat.vo.RestituteDetailVO;
import com.ejianc.business.assist.rmat.vo.RestituteMaintainVO;
import com.ejianc.business.assist.rmat.vo.RestituteOtherVO;
import com.ejianc.business.assist.rmat.vo.RestituteScrapVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * out-退赔单
 * 
 * @author generator
 * 
 */
@ApiModel("out-退赔单")
public class OutRmatRestituteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date stopDate; // 止租日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 部门
    private String deptName; // 部门名称
    private Long supplierId; // 供方主键
    private String supplierName; // 供方名称
    private String memo; // 备注
    private String confirmState; // 是否确认
    private Integer supplierSignStatus; // 签字状态(已签字-1,未签字-0)
    private String supOperatorName; // 供方经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime; // 供方经办人签字时间
    private String supOperatorPhone; // 供方经办人手机号
    private String supOperatorUserCode; // 供方经办人账号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date restituteDate; // 退赔日期
    private String supplierSignStatusName;//签字状态
    private String billStateName;//单据状态
    private String materialTypeNames; // 材料分类
    private Long supOperateFileId;// 供方经办人签字文件id
    private String sourceSystemId;// 来源业务系统id
    private Long firstPartyId;//甲方Id
    private String firstPartyName;//甲方名称
    private String billPushFlag;// 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitTime;//单据提交时间
    private Integer settleFlag;//是否结算
    private BigDecimal totalMaintainTaxMny; // 本次维修金额汇总
    private BigDecimal totalMaintainMny; // 本次维修金额汇总(无税)
    private BigDecimal totalMaintainTax; // 维修税额
    private BigDecimal totalScrapTaxMny; // 损坏赔偿金额(含税)
    private BigDecimal totalScrapMny; // 损坏赔偿金额
    private BigDecimal totalScrapTax; // 损坏赔偿税额
    private Long restituteUnit;//退赔单位Id
    private String restituteUnitName;//退赔单位名称
    private BigDecimal taxRate; // 税率

    private List<OutRmatRestituteDetailVO> restituteDetailList = new ArrayList<>(); // 退赔单材料明细实体
    private List<OutRmatRestituteMaintainVO> restituteMaintainList = new ArrayList<>(); // 退赔单维修清单明细
    private List<OutRmatRestituteScrapVO> restituteScrapList = new ArrayList<>(); // 退赔单报废清单明细
    private List<OutRmatRestituteOtherVO> otherList = new ArrayList<>(); // 退赔单其他费用明细

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "arri_contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getStopDate() {
        return stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getConfirmState() {
        return confirmState;
    }

    public void setConfirmState(String confirmState) {
        this.confirmState = confirmState;
    }
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public Date getRestituteDate() {
        return restituteDate;
    }

    public void setRestituteDate(Date restituteDate) {
        this.restituteDate = restituteDate;
    }

    public String getSupplierSignStatusName() {
        return supplierSignStatusName;
    }

    public void setSupplierSignStatusName(String supplierSignStatusName) {
        this.supplierSignStatusName = supplierSignStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getFirstPartyId() {
        return firstPartyId;
    }
    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Date getSubmitTime() {
        return submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public BigDecimal getTotalMaintainTaxMny() {
        return totalMaintainTaxMny;
    }

    public void setTotalMaintainTaxMny(BigDecimal totalMaintainTaxMny) {
        this.totalMaintainTaxMny = totalMaintainTaxMny;
    }

    public BigDecimal getTotalMaintainMny() {
        return totalMaintainMny;
    }

    public void setTotalMaintainMny(BigDecimal totalMaintainMny) {
        this.totalMaintainMny = totalMaintainMny;
    }

    public BigDecimal getTotalMaintainTax() {
        return totalMaintainTax;
    }

    public void setTotalMaintainTax(BigDecimal totalMaintainTax) {
        this.totalMaintainTax = totalMaintainTax;
    }

    public BigDecimal getTotalScrapTaxMny() {
        return totalScrapTaxMny;
    }

    public void setTotalScrapTaxMny(BigDecimal totalScrapTaxMny) {
        this.totalScrapTaxMny = totalScrapTaxMny;
    }

    public BigDecimal getTotalScrapMny() {
        return totalScrapMny;
    }

    public void setTotalScrapMny(BigDecimal totalScrapMny) {
        this.totalScrapMny = totalScrapMny;
    }

    public BigDecimal getTotalScrapTax() {
        return totalScrapTax;
    }

    public void setTotalScrapTax(BigDecimal totalScrapTax) {
        this.totalScrapTax = totalScrapTax;
    }

    public List<OutRmatRestituteDetailVO> getRestituteDetailList() {
        return restituteDetailList;
    }

    public void setRestituteDetailList(List<OutRmatRestituteDetailVO> restituteDetailList) {
        this.restituteDetailList = restituteDetailList;
    }

    public List<OutRmatRestituteMaintainVO> getRestituteMaintainList() {
        return restituteMaintainList;
    }

    public void setRestituteMaintainList(List<OutRmatRestituteMaintainVO> restituteMaintainList) {
        this.restituteMaintainList = restituteMaintainList;
    }

    public List<OutRmatRestituteScrapVO> getRestituteScrapList() {
        return restituteScrapList;
    }

    public void setRestituteScrapList(List<OutRmatRestituteScrapVO> restituteScrapList) {
        this.restituteScrapList = restituteScrapList;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getRestituteUnit() {
        return restituteUnit;
    }
    @ReferDeserialTransfer
    public void setRestituteUnit(Long restituteUnit) {
        this.restituteUnit = restituteUnit;
    }

    public String getRestituteUnitName() {
        return restituteUnitName;
    }

    public void setRestituteUnitName(String restituteUnitName) {
        this.restituteUnitName = restituteUnitName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public List<OutRmatRestituteOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<OutRmatRestituteOtherVO> otherList) {
        this.otherList = otherList;
    }
}
