package com.ejianc.business.outrmat.contract.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 周转材租赁合同-付款阶段变更表
 * 
 * @author generator
 * 
 */
public class OutRmatContractChangePaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 通用变更类型：0-新增项
     */
    public static final Integer CHANGE_TYPE_ADD = 0;
    /**
     * 通用变更类型：1-删除项
     */
    public static final Integer CHANGE_TYPE_DEL = 1;
    /**
     * 通用变更类型：2-内容便更
     */
    public static final Integer CHANGE_TYPE_CONTENT_CHANGE = 2;
    
    
    private Long changeId; // 变更主键
    private String changeType; // 变更类型
    private Long contractId; // 合同id
    private Long sourceId; // 来源数据Id(参照数据id)
    private Long sourceBid; // 来源子表主键(合同子表id)
    private String sourceType; // 来源类型：0-直接新增，1-定标结果带入
    private String paymentName; // 付款阶段名称
    private BigDecimal paymentScale; // 付款阶段比例(%)
    private String memo; // 备注

    private String bcPaymentName; // 变更前付款阶段名称
    private BigDecimal bcPaymentScale; // 变更前付款阶段比例(%)
    
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }
    public BigDecimal getPaymentScale() {
        return paymentScale;
    }

    public void setPaymentScale(BigDecimal paymentScale) {
        this.paymentScale = paymentScale;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBcPaymentName() {
        return bcPaymentName;
    }

    public void setBcPaymentName(String bcPaymentName) {
        this.bcPaymentName = bcPaymentName;
    }

    public BigDecimal getBcPaymentScale() {
        return bcPaymentScale;
    }

    public void setBcPaymentScale(BigDecimal bcPaymentScale) {
        this.bcPaymentScale = bcPaymentScale;
    }
}
