/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.ejianc.business.assist.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.assist.ownrmat.mapper.AllotOutMapper;
import com.ejianc.business.assist.ownrmat.service.IAllotOutService;
import com.ejianc.business.assist.ownrmat.vo.AllotOutDetailVO;
import com.ejianc.business.assist.ownrmat.vo.AllotOutExportVO;
import com.ejianc.business.assist.ownrmat.vo.AllotOutVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocatEnum;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotOutService")
public class AllotOutServiceImpl
extends BaseServiceImpl<AllotOutMapper, AllotOutEntity>
implements IAllotOutService {
    public static String NOT_CHANGE = "\u6750\u6599\u51fa\u5e93\u660e\u7ec6\u6570\u91cf\u6ca1\u6709\u53d8\u5316,\u4ed3\u5e93\u65e0\u9700\u5904\u7406!";
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRO_RMAT_ALLOT_OUT";

    @Override
    public CommonResponse<UseMaterialPriceVO> turnSurplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        AllotOutDetailVO allotOutDetailVO = (AllotOutDetailVO)saveOrUpdateVO.getAllotOutDetailList().get(0);
        FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)StoreCommonConsts.NO);
        flowVO.setRowState(allotOutDetailVO.getRowState());
        flowVO.setProjectId(saveOrUpdateVO.getProjectId());
        flowVO.setProjectName(saveOrUpdateVO.getProjectName());
        flowVO.setParentOrgId(saveOrUpdateVO.getParentOrgId());
        flowVO.setParentOrgCode(saveOrUpdateVO.getParentOrgCode());
        flowVO.setParentOrgName(saveOrUpdateVO.getParentOrgName());
        flowVO.setOrgId(saveOrUpdateVO.getOrgId());
        flowVO.setOrgName(saveOrUpdateVO.getOrgName());
        flowVO.setStoreId(saveOrUpdateVO.getStoreId());
        flowVO.setStoreName(saveOrUpdateVO.getStoreName());
        flowVO.setMaterialId(allotOutDetailVO.getMaterialId());
        flowVO.setMaterialName(allotOutDetailVO.getMaterialName());
        flowVO.setMaterialCategoryId(allotOutDetailVO.getMaterialCategoryId());
        flowVO.setMaterialCategoryName(allotOutDetailVO.getMaterialCategoryName());
        flowVO.setMaterialSpec(allotOutDetailVO.getMaterialSpec());
        flowVO.setMaterialUnitId(allotOutDetailVO.getMaterialUnitId());
        flowVO.setMaterialUnitName(allotOutDetailVO.getMaterialUnit());
        flowVO.setNum(allotOutDetailVO.getAllocatNum());
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
        storeManageVO.setSourceId(saveOrUpdateVO.getId());
        ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
        flowVOList.add(flowVO);
        storeManageVO.setFlowVOList(flowVOList);
        CommonResponse commonResponse = this.storeManageApi.turnSurplusMaterialPrice(storeManageVO);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            return CommonResponse.success((String)"\u539f\u503c\u5355\u4ef7\u3001\u51c0\u503c\u91d1\u989d\u83b7\u53d6\u6210\u529f", ((StoreManageVO)commonResponse.getData()).getUseMaterialPriceVOList().get(0));
        }
        if (NOT_CHANGE.equals(commonResponse.getMsg())) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)commonResponse.getMsg());
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {
        boolean b;
        AllotOutEntity entity = (AllotOutEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllotOutEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setReceiveState(Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((b = this.service.saveOrUpdate((Object)entity, false)) && CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getAllotOutDetailList())) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(saveOrUpdateVO.getStoreId());
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            ArrayList flowVOS = new ArrayList();
            saveOrUpdateVO.getAllotOutDetailList().forEach(t -> {
                if ("del".equals(t.getRowState())) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)0);
                    flowVO.setStoreId(entity.getStoreId());
                    flowVO.setStoreName(entity.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(entity.getEmployeeId());
                    flowVO.setEmployeeName(entity.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialSpec(t.getMaterialSpec());
                    flowVO.setMaterialUnitId(t.getMaterialUnitId());
                    flowVO.setMaterialUnitName(t.getMaterialName());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getAllocatTaxPrice());
                    flowVO.setPrice(t.getAllocatPrice());
                    flowVO.setNum(t.getAllocatNum());
                    flowVO.setTaxMny(t.getAllocatTaxMny());
                    flowVO.setMny(t.getAllocatMny());
                    flowVO.setTax(t.getAllocatTax());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getOutDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getMemo());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                }
            });
            entity.getAllotOutDetailList().forEach(t -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getAllocatTaxPrice());
                flowVO.setPrice(t.getAllocatPrice());
                flowVO.setNum(t.getAllocatNum());
                flowVO.setTaxMny(t.getAllocatTaxMny());
                flowVO.setMny(t.getAllocatMny());
                flowVO.setTax(t.getAllocatTax());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getOutDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVO.setPurchasePrice(t.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        AllotOutVO vo = (AllotOutVO)BeanMapper.map((Object)((Object)entity), AllotOutVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u4fee\u6539\u6210\u529f", (Object)vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(vo.getId()));
                if (!CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutEntity.getStoreId());
                storeManageVO.setSourceId(allotOutEntity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93);
                storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(allotOutEntity.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        boolean b = this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List allotOutVos = BeanMapper.mapList((Iterable)list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }
}

