/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.RentCalculateEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.mapper.RentCalculateMapper;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IRentCalculateService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.RentCalculateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentCalculateService")
public class RentCalculateServiceImpl
extends BaseServiceImpl<RentCalculateMapper, RentCalculateEntity>
implements IRentCalculateService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialService materialService;
    private static final String BILL_CODE = "ASSIST_RMAT_RENT_CALCULATE";
    private static final String BILL_NAME = BillTypeEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName();

    @Override
    public RentCalculateVO saveOrUpdate(RentCalculateVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        RentCalculateEntity entity = (RentCalculateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentCalculateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (RentCalculateVO)BeanMapper.map((Object)((Object)entity), RentCalculateVO.class);
    }

    @Override
    public String validateTime(RentCalculateVO rentVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", rentVO.getContractId());
        if (rentVO.getId() != null) {
            params.put("billType", BILL_NAME);
            params.put("billId", rentVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(rentVO.getRentDate(), lastDate, maxTimeMap, rentVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(rentVO.getRentDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

