package com.ejianc.business.assist.ownrmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.assist.ownrmat.bean.AllotOutDetailEntity;
import com.ejianc.business.assist.ownrmat.bean.AllotInEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周转材调出
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assistownrmat_allot_out")
 public class AllotOutEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="project_name")
    private String projectName; // 出库项目名称
    @TableField(value="org_id")
    private Long orgId; // 出库组织id
    @TableField(value="org_name")
    private String orgName; // 出库组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="store_id")
    private Long storeId; // 出库仓库id
    @TableField(value="store_name")
    private String storeName; // 出库仓库名称
    @TableField(value="out_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 调出的时间
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出金额
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 调出金额
    @TableField(value="allocat_type")
    private Integer allocatType; // 调拨方式 1 资产盘活 2 自制
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; //  经办人部门
    @TableField(value="in_project_id")
    private Long inProjectId; // 调入项目id
    @TableField(value="in_project_name")
    private String inProjectName; // 调入项目名称
    @TableField(value="in_parent_org_id")
    private Long inParentOrgId; // 调入项目部上级组织Id
    @TableField(value="in_parent_org_name")
    private String inParentOrgName; // 调入项目部上级组织名称
    @TableField(value="in_parent_org_code")
    private String inParentOrgCode; // 调入项目部上级组织编码
    @TableField(value="in_org_id")
    private Long inOrgId; // 调入组织id
    @TableField(value="in_org_name")
    private String inOrgName; // 调入组织名称
    @TableField(value="material_names")
    private String materialNames; // 出库物资名称集合
    @TableField(value="receiver_id")
    private Long receiverId; // 通知收料状人id
    @TableField(value="receiver_name")
    private String receiverName; // 通知收料状人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="return_reason")
    private String returnReason; // 调入组织退回原因
    @TableField(value="receive_state")
    private Integer receiveState; // 收料状态 1、待收；2、已收；3、退回
    @TableField(value="receiver_person_id")
    private Long receiverPersonId; // 收料人id
    @TableField(value="receiver_person")
    private String receiverPerson; // 收料人

    @TableField(value="in_store_id")
    private Long inStoreId; // 收料人
    @TableField(value="in_store_name")
    private String inStoreName; // 收料人
    @TableField(value="receive_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiveDate; // 收料时间

    @TableField(value="out_alloca_scope")
    private String outAllocaScope; // 调出调拨范围(0-项目，1-组织)
    @TableField(value="in_alloca_scope")
    private String inAllocaScope; // 调入调拨范围(0-项目，1-组织)

    @TableField(exist=false)
    @SubEntity(serviceName="allotOutDetailService",pidName ="allocatId")
    private List<AllotOutDetailEntity> allotOutDetailList = new ArrayList<>(); // 调拨出库子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public Integer getAllocatType() {
        return allocatType;
    }

    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getInProjectId() {
        return inProjectId;
    }

    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }

    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }

    public Long getInParentOrgId() {
        return inParentOrgId;
    }

    public void setInParentOrgId(Long inParentOrgId) {
        this.inParentOrgId = inParentOrgId;
    }

    public String getInParentOrgName() {
        return inParentOrgName;
    }

    public void setInParentOrgName(String inParentOrgName) {
        this.inParentOrgName = inParentOrgName;
    }

    public String getInParentOrgCode() {
        return inParentOrgCode;
    }

    public void setInParentOrgCode(String inParentOrgCode) {
        this.inParentOrgCode = inParentOrgCode;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public Long getReceiverId() {
        return receiverId;
    }

    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }
    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }


    public List<AllotOutDetailEntity> getAllotOutDetailList() {
        return allotOutDetailList;
    }

    public void setAllotOutDetailList(List<AllotOutDetailEntity> allotOutDetailList) {
        this.allotOutDetailList = allotOutDetailList;
    }

    public Long getReceiverPersonId() {
        return receiverPersonId;
    }

    public void setReceiverPersonId(Long receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }

    public String getReceiverPerson() {
        return receiverPerson;
    }

    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public String getOutAllocaScope() {
        return outAllocaScope;
    }

    public void setOutAllocaScope(String outAllocaScope) {
        this.outAllocaScope = outAllocaScope;
    }

    public String getInAllocaScope() {
        return inAllocaScope;
    }

    public void setInAllocaScope(String inAllocaScope) {
        this.inAllocaScope = inAllocaScope;
    }
}
