package com.ejianc.business.assist.ownrmat.service;

import com.ejianc.business.assist.ownrmat.vo.AllotOutVO;
import com.ejianc.business.assist.ownrmat.vo.HandleVO;
import com.ejianc.framework.core.response.QueryParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 材料公共接口
 * 
 * @author generator
 * 
 */
public interface IValidateService {

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（调出、处置、摊销）
     * @param projectId   项目主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @param type 保存/弃审
     * @return
     */
    String validateProject(Long projectId, String billType, Long billId, String type);

    /**
     * 获取最大单据日期（调出、处置、摊销，只取主表单据日期，包含未生效单据）
     * @param params    contractId，billType，billId
     * @return
     */
    Date getLastDate(Map<String, Object> params);

    /**
     * 获取同一天最大制单日期（调出、处置、摊销，只取主表单据日期，包含未生效单据）
     * @param params    contractId，billType，billId
     * @return
     */
    Map<Date, Date> getMaxTime(Map<String, Object> params);


    /**
     * 调拨出库校验库存数量和调拨数量
     * @param allotOutVO
     * @return
     */
    String validateAllotOut(AllotOutVO allotOutVO);

    /**
     * 周转材处置校验库存数量和处置数量
     * @param handleVO
     * @return
     */
    String validateHandle(HandleVO handleVO);

}
