package com.ejianc.business.assist.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.assist.ownrmat.bean.AllotInDetailEntity;
import com.ejianc.business.assist.ownrmat.bean.AllotInEntity;
import com.ejianc.business.assist.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.assist.ownrmat.service.IAllotInService;
import com.ejianc.business.assist.ownrmat.service.IAllotOutService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.vo.AllotInVO;
import com.ejianc.business.assist.ownrmat.vo.AllotOutVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocationState;

import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service("allotOut") 
public class AllotOutBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IAllotOutService service;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAllotInService allotInService;

	private static final String BILL_CODE = "PRO_RMAT_ALLOT_IN";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private JedisPool jedisPool;
	@Autowired
	private IStoreManageApi storeManageApi;

	@Autowired
	private IValidateService validateService;


	/*@Autowired
	private AllotInMessageService allotInMessageService;*/

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		AllotOutEntity allotOutEntity = service.selectById(billId);
		AllotOutVO allotOutVO = BeanMapper.map(allotOutEntity, AllotOutVO.class);
		validateService.validateAllotOut(allotOutVO);
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//加锁防止生成多个调拨入库
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		if (locked){
			try{
				//更新流水
				AllotOutEntity allotOutEntity = service.selectById(billId);
				AllotOutVO allotOutVO = BeanMapper.map(allotOutEntity, AllotOutVO.class);
				StoreManageVO storeManageVO = allotOutVO.getStoreManageVO(allotOutVO);
				storeManageVO.setOutEffectiveON(true);
				CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
				if(!response.isSuccess()) {
					throw new BusinessException("调用库存管理失败,错误信息：" + response.getMsg());
				}

				if (!Objects.isNull(allotOutEntity)){
					//再次提交 收料状态设置带收清空退回原因
					if (allotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))){
						LambdaUpdateWrapper<AllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
						allotOutWrapper.eq(AllotOutEntity::getId, billId);
						allotOutWrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
						allotOutWrapper.set(AllotOutEntity::getReturnReason,null);
						allotOutWrapper.set(AllotOutEntity::getReceiverPersonId,null);
						allotOutWrapper.set(AllotOutEntity::getReceiverPerson,null);
						service.update(allotOutWrapper);
					}
					//生成调拨入库
					AllotInEntity allotInEntity = new AllotInEntity();
					//出库信息
					allotInEntity.setOutAllocaScope(allotOutEntity.getOutAllocaScope());
					allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
					allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
					allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
					allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
					//入库信息
					allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
					allotInEntity.setInAllocaScope(allotOutEntity.getInAllocaScope());
					allotInEntity.setStoreId(allotOutEntity.getInStoreId());
					allotInEntity.setStoreName(allotOutEntity.getInStoreName());
					allotInEntity.setProjectId(allotOutEntity.getInProjectId());
					allotInEntity.setProjectName(allotOutEntity.getInProjectName());
					allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
					allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
					allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
					allotInEntity.setOrgId(allotOutEntity.getInOrgId());
					allotInEntity.setOrgName(allotOutEntity.getInOrgName());
					allotInEntity.setAllotOutId(allotOutEntity.getId());
					allotInEntity.setOutMny(allotOutEntity.getOutMny());
					allotInEntity.setOutDate(allotOutEntity.getOutDate());
					allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
					allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
					allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
					allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
					allotInEntity.setOutStoreId(allotOutEntity.getStoreId());
					allotInEntity.setOutStoreName(allotOutEntity.getStoreName());
					allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
					allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
					allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
					allotInEntity.setMemo(allotOutEntity.getMemo());
					allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
					allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
					List<AllotInDetailEntity> allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
					long id = IdWorker.getId();
					allotInDetailEntitys.forEach(item->{
						item.setId(null);
						item.setAllocatId(id);
					});
					allotInEntity.setAllotInDetailList(allotInDetailEntitys);
					AllotInVO vo = BeanMapper.map(allotInEntity, AllotInVO.class);
					BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
					CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
					if(billCode.isSuccess()) {
						allotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
					}else{
						throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
					logger.info("子表信息："+allotInDetailEntitys.toString());
					allotInEntity.setId(id);
					boolean b = allotInService.saveOrUpdate(allotInEntity,false);
					if (b){
						AllotInEntity allot = allotInService.selectById(id);
						if ((allot!=null) && (allot.getNotifyReceiverId()!=null)){
							//通知收料人收料
							String[] notifyReceive = {String.valueOf(allot.getNotifyReceiverId())};

							//serviec不存在暂时注释
							//allotInMessageService.sendMsg(allot,notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
						}
					}
				}
			}catch (Exception e){
				e.printStackTrace();
			} finally {
				if(locked) {
					RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
				}
				jedis.close();
			}
		} else{
			return CommonResponse.error("出现并发操作,请稍后重试！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不支持弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
