package com.ejianc.business.assist.ownrmat.service.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.assist.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.assist.ownrmat.bean.HandleEntity;
import com.ejianc.business.assist.ownrmat.bean.OwnEntity;
import com.ejianc.business.assist.ownrmat.service.IAllotOutService;
import com.ejianc.business.assist.ownrmat.service.IHandleService;
import com.ejianc.business.assist.ownrmat.service.IOwnService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.utils.ListCallable;
import com.ejianc.business.assist.ownrmat.utils.MaterialConstant;
import com.ejianc.business.assist.ownrmat.vo.*;
import com.ejianc.business.assist.ownrmat.mapper.ValidateMapper;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 公共校验接口
 * 
 * @author generator
 * 
 */
@Service("validateService")
public class ValidateServiceImpl implements IValidateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static String NOT_CHANGE = "材料出库明细数量没有变化,仓库无需处理!";

    @Autowired
    private ValidateMapper baseMapper;

    @Autowired
    private IHandleService handleService;

    @Autowired
    private IAllotOutService outService;

    @Autowired
    private IOwnService ownService;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Override
    public String validateProject(Long projectId, String billType, Long billId, String type) {
        // 同一个项目只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        QueryParam param = Utils.deepCopy(queryParam);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.周转材调出.equals(billType) ? param : queryParam,outService );// 周转材调出
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.周转材处置.equals(billType) ? param : queryParam, handleService);// 周转材处置
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.自有材料摊销.equals(billType) ? param : queryParam, ownService);// 自有材料摊销

        List<AllotOutEntity> outList = new ArrayList<>();// 周转材调出
        List<HandleEntity> HandleList = new ArrayList<>();// 周转材处置
        List<OwnEntity> ownList = new ArrayList<>();// 自有材料摊销
        try {
            outList = JSONObject.parseArray(future1.get().toJSONString(), AllotOutEntity.class);
            HandleList = JSONObject.parseArray(future2.get().toJSONString(), HandleEntity.class);
            ownList = JSONObject.parseArray(future3.get().toJSONString(), OwnEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(CollectionUtils.isNotEmpty(outList)){
            throw new BusinessException("当前项目存在非审批通过态的周转材调出，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(HandleList)){
            throw new BusinessException("当前项目存在非审批通过态的周转材处置，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(ownList)){
            throw new BusinessException("当前项目存在非审批通过态的自有材料摊销，不允许" + type + "!");
        }
        return "校验通过！";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        return list.stream().filter(x->x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public String validateAllotOut(AllotOutVO allotOutVO) {
        List<AllotOutDetailVO> outDetailVOList = allotOutVO.getAllotOutDetailList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outDetailVOList)){
            for (AllotOutDetailVO allotOutDetailVO : outDetailVOList){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材调拨出库, StoreCommonConsts.NO);

                flowVO.setRowState(allotOutDetailVO.getRowState());
                flowVO.setProjectId(allotOutVO.getProjectId());
                flowVO.setProjectName(allotOutVO.getProjectName());
                flowVO.setParentOrgId(allotOutVO.getParentOrgId());
                flowVO.setParentOrgCode(allotOutVO.getParentOrgCode());
                flowVO.setParentOrgName(allotOutVO.getParentOrgName());
                flowVO.setOrgId(allotOutVO.getOrgId());
                flowVO.setOrgName(allotOutVO.getOrgName());
                flowVO.setStoreId(allotOutVO.getStoreId());
                flowVO.setStoreName(allotOutVO.getStoreName());
                flowVO.setMaterialId(allotOutDetailVO.getMaterialId());
                flowVO.setMaterialName(allotOutDetailVO.getMaterialName());
                flowVO.setMaterialCategoryId(allotOutDetailVO.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(allotOutDetailVO.getMaterialCategoryName());
                flowVO.setMaterialSpec(allotOutDetailVO.getMaterialSpec());
                flowVO.setMaterialUnitId(allotOutDetailVO.getMaterialUnitId());
                flowVO.setMaterialUnitName(allotOutDetailVO.getMaterialUnit());
                flowVO.setNum(allotOutDetailVO.getAllocatNum());

                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutVO.getStoreId());
                storeManageVO.setSourceId(allotOutVO.getId());
                List<FlowVO> flowVOList = new ArrayList<>();
                flowVOList.add(flowVO);
                storeManageVO.setFlowVOList(flowVOList);

                CommonResponse<StoreManageVO> commonResponse = storeManageApi.turnSurplusMaterialPrice(storeManageVO);
                if (!commonResponse.isSuccess()&&!NOT_CHANGE.equals(commonResponse.getMsg())){
                    throw new BusinessException(commonResponse.getMsg()+"不允许提交！");
                }
            }
        }
        return "校验成功";
    }

    @Override
    public String validateHandle(HandleVO handleVO) {
        List<HandleDetailVO> outDetailVOList = handleVO.getHandleSubList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outDetailVOList)){
            for (HandleDetailVO handleDetailVO : outDetailVOList){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材材料处置, StoreCommonConsts.NO);

                flowVO.setRowState(handleDetailVO.getRowState());
                flowVO.setProjectId(handleVO.getProjectId());
                flowVO.setProjectName(handleVO.getProjectName());
                flowVO.setParentOrgId(handleVO.getParentOrgId());
                flowVO.setParentOrgCode(handleVO.getParentOrgCode());
                flowVO.setParentOrgName(handleVO.getParentOrgName());
                flowVO.setOrgId(handleVO.getOrgId());
                flowVO.setOrgName(handleVO.getOrgName());
                flowVO.setStoreId(handleVO.getStoreId());
                flowVO.setStoreName(handleVO.getStoreName());
                flowVO.setMaterialId(handleDetailVO.getMaterialId());
                flowVO.setMaterialName(handleDetailVO.getMaterialName());
                flowVO.setMaterialCategoryId(handleDetailVO.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(handleDetailVO.getMaterialCategoryName());
                flowVO.setMaterialSpec(handleDetailVO.getSpec());
                flowVO.setMaterialUnitId(handleDetailVO.getUnit());
                flowVO.setMaterialUnitName(handleDetailVO.getUnitName());
                flowVO.setNum(handleDetailVO.getHandleNum());

                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(handleVO.getStoreId());
                storeManageVO.setSourceId(handleVO.getId());
                List<FlowVO> flowVOList = new ArrayList<>();
                flowVOList.add(flowVO);
                storeManageVO.setFlowVOList(flowVOList);

                CommonResponse<StoreManageVO> commonResponse = storeManageApi.turnSurplusMaterialPrice(storeManageVO);
                if (!commonResponse.isSuccess()&&!NOT_CHANGE.equals(commonResponse.getMsg())){
                    throw new BusinessException(commonResponse.getMsg()+"不允许提交！");
                }
            }
        }
        return "校验成功";
    }

}
