package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.*;

@Service("totalPlanChange") 
public class TotalPlanChangeBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	public static final String TOTAL_PLAN_BILL_TYPE = "BT220209000000005";
	public static final String TOTAL_PLAN_CHANGE_BILL_TYPE = "BT220211000000005";
	public static final String TOTAL_PLAN_SOURCE_TYPE = "proTotalPlan";
	public static final String TOTAL_PLAN_CHANGE_SOURCE_TYPE = "proTotalPlanChange";
	
	@Autowired
	private ITotalPlanChangeService changeService;
	@Autowired
	private ITotalPlanService totalPlanService;
	@Autowired
	private ITotalPlanDetailService totalDetailService;
	@Autowired
	private ITotalPlanHistoryService historyService;
	@Autowired
	private ITotalPlanDetailHistoryService historyDetailService;

	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//1是直审，2是有审批流
		logger.info("--------------总计划变更审批通过，处理业务");
		//变更表
		TotalPlanChangeEntity entity = changeService.selectById(billId);
		List<TotalPlanDetailChangeEntity> yearPlanChangeDetailEntities = entity.getDetailList();
		//合同主表
		TotalPlanEntity contractEntity = totalPlanService.selectById(entity.getTotalId());

		//同步原合同到记录表
		logger.info("--------------同步原始总计划到记录表");
		TotalPlanHistoryEntity historyEntity = BeanMapper.map(contractEntity, TotalPlanHistoryEntity.class);
		historyEntity.setTotalId(entity.getTotalId());//原合同主键
		historyEntity.setId(null);
		historyEntity.setCreateTime(new Date());
		historyEntity.setDetailList(null);
		historyService.saveOrUpdate(historyEntity, false);

		//同步原清单到记录表
		logger.info("--------------同步原始总计划清单到记录表");
		List<TotalPlanDetailEntity> checkList = contractEntity.getDetailList();
		if (null != checkList && checkList.size() > 0) {
			List<TotalPlanDetailHistoryEntity> historyDetails = BeanMapper.mapList(checkList, TotalPlanDetailHistoryEntity.class);
			for (TotalPlanDetailHistoryEntity hde : historyDetails) {
				hde.setHistoryId(historyEntity.getId());//记录表主键
				hde.setTotalId(entity.getTotalId());//原合同主键
				hde.setTotalBid(hde.getId());//原子表id
				hde.setId(null);
			}
			historyDetailService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);
		}

		//回写合同主表
		TotalPlanEntity newEntity = BeanMapper.map(entity, TotalPlanEntity.class);
		newEntity.setId(contractEntity.getId());
		newEntity.setBaseMny(contractEntity.getBaseMny());
		newEntity.setChangingMny(null);
		newEntity.setChangeStatus(3);//状态改为已变更
		newEntity.setChangeCode(contractEntity.getChangeCode());
		newEntity.setChangeId(contractEntity.getChangeId());
		newEntity.setBillState(contractEntity.getBillState());
		newEntity.setCreateTime(contractEntity.getCreateTime());
		newEntity.setVersion(contractEntity.getVersion());
		newEntity.setDetailList(null);
		logger.info("--------------变更总计划回写到原始总计划");
		totalPlanService.saveOrUpdate(newEntity);

		// 回写原合同清单表
		logger.info("--------------变更总计划清单回写到原始总计划清单");
		totalPlanService.delByPlanId(contractEntity.getId());

		if (CollectionUtils.isNotEmpty(yearPlanChangeDetailEntities)) {
			List<TotalPlanDetailEntity> detailEntitys = BeanMapper.mapList(yearPlanChangeDetailEntities,TotalPlanDetailEntity.class);
			for(TotalPlanDetailEntity detailEntity : detailEntitys){
				detailEntity.setTotalId(entity.getTotalId());
			}
			totalDetailService.saveOrUpdateBatch(detailEntitys, detailEntitys.size(), false);
		}

		logger.info("--------------处理总计划变更单");
		entity.setUsedTime(new Date());
		changeService.saveOrUpdate(entity, false);

		logger.info("--------------处理变更附件");
		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), TOTAL_PLAN_CHANGE_BILL_TYPE, TOTAL_PLAN_CHANGE_SOURCE_TYPE,
				String.valueOf(contractEntity.getId()), TOTAL_PLAN_BILL_TYPE, TOTAL_PLAN_SOURCE_TYPE);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
