package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.assist.store.bean.AllotOutEntity;
import com.ejianc.business.assist.store.consts.AllocatEnum;
import com.ejianc.business.assist.store.consts.AllocationState;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.mapper.AllotOutMapper;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 调拨出库
 *
 * @author generator
 */
@Service("allotOutService")
public class AllotOutServiceImpl extends BaseServiceImpl<AllotOutMapper, AllotOutEntity> implements IAllotOutService {
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "STORE_ALLOT_OUT";//此处需要根据实际修改
    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public CommonResponse<StoreManageVO> surplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
        CommonResponse<StoreManageVO> commonResponse = storeManageService.surplusMaterialPrice(storeManageVO);
        return commonResponse;
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {

        //保存修改
        AllotOutEntity entity = BeanMapper.map(saveOrUpdateVO, AllotOutEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean b = service.saveOrUpdate(entity, false);
        ////生成出库流水 生成
        if (b) {
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())) {
                saveOrUpdateVO.setId(entity.getId());
                saveOrUpdateVO.setBillCode(entity.getBillCode());
                StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
                storeManageService.inOutStore(storeManageVO);
            }
        }
        AllotOutVO vo = BeanMapper.map(entity, AllotOutVO.class);
        return CommonResponse.success("保存修改成功", vo);
    }

    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {

        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = service.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(allotOutEntity.getStoreId());
                    storeManageVO.setSourceId(allotOutEntity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
                    ArrayList<Long> longs = new ArrayList<>();
                    longs.add(allotOutEntity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    storeManageService.inOutStoreRollback(storeManageVO);
                }
            }
        }

        boolean b = service.removeByIds(vos.stream().map(AllotOutVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllotOutEntity> list = service.queryList(param);
        List<AllotOutExportVO> allotOutVos = BeanMapper.mapList(list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }
}
