package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.consts.FlowTypeEnum;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.mapper.RmatFlowMapper;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.rmat.vo.RmatFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租赁流水表
 * 
 * @author generator
 * 
 */
@Service("rmatFlowService")
public class RmatFlowServiceImpl extends BaseServiceImpl<RmatFlowMapper, RmatFlowEntity> implements IRmatFlowService{

    @Override
    public Boolean insertFlow(List<RmatFlowVO> vos) {
        List<RmatFlowVO> addList = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        for(RmatFlowVO vo : vos){
            vo.setId(vo.getSourceDetailId());// 默认主键为子表主键
            if(!"del".equals(vo.getRowState())){
                addList.add(vo);
            } else {
                delIds.add(vo.getId());
            }
        }
        if(CollectionUtils.isNotEmpty(addList)){
            List<RmatFlowEntity> list = BeanMapper.mapList(addList, RmatFlowEntity.class);
            super.saveOrUpdateBatch(list);
        }
        if(CollectionUtils.isNotEmpty(delIds)){
            super.removeByIds(delIds);
        }
        return true;
    }

    @Override
    public Boolean insertCheckFlow(CheckEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<CheckDetailEntity> detailList = entity.getCheckDetailList();
        for(CheckDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 上级组织作为仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getCheckDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.验收.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getCheckNumsSum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertStopFlow(StopEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<StopDetailEntity> detailList = entity.getDetailList();
        for(StopDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.停用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));// 停用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertStartFlow(StartEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<StartDetailEntity> detailList = entity.getDetailList();
        for(StartDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStartTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.启用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertRestFlow(RestituteEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<RestituteDetailEntity> detailList = entity.getRestituteDetailList();
        for(RestituteDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.退赔.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(ComputeUtil.safeAdd(detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum()));// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertLoseFlow(LoseEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<LoseDetailEntity> detailList = entity.getLoseDetailList();
        for(LoseDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setStoreId(entity.getParentOrgId());// 仓库
            vo.setStoreName(entity.getParentOrgName());
            vo.setParentOrgId(entity.getParentOrgId());// 上级组织
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.遗失.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitMId());// 主单位
            vo.setUnitName(detail.getUnitMName());
            vo.setNum(detail.getNumM());// 主数量
            vo.setAssistUnitId(detail.getUnitId());// 辅单位
            vo.setAssistUnitName(detail.getUnitName());
            vo.setAssistNum(detail.getLoseNum());// 辅数量
            vo.setTransScale(detail.getTransScale());// 转换系数
            vo.setRentCalculationType(detail.getRentCalculationType());// 计租方式：0-日租，1-月租，2-工程量租
            vo.setContractRmatMethod(String.valueOf(RmatCommonConsts.CONT_OUT));// 合同租赁方式(0-外租，1-内租)
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, String billTypeCode) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return true;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in("source_id", sourceIds);
        ew.eq("bill_type_code", billTypeCode);
        return super.remove(ew);
    }


}
