/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.store.bean.AllotOutEntity;
import com.ejianc.business.assist.store.consts.AllocationState;
import com.ejianc.business.assist.store.service.IAllotOutService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.pro.ownrmat.api.IAllotOutApi;
import com.ejianc.business.pro.ownrmat.vo.AllotOutVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="allotOut")
public class AllotOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOutService service;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private IAllotOutApi allotOutApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Jedis jedis = this.jedisPool.getResource();
        boolean locked = false;
        locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
        if (locked) {
            RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
        }
        locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
        this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
        try {
            if (!locked) throw new BusinessException("\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
            com.ejianc.business.assist.store.vo.AllotOutVO allotoutvo = (com.ejianc.business.assist.store.vo.AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), com.ejianc.business.assist.store.vo.AllotOutVO.class);
            StoreManageVO storeManageVO = allotoutvo.getStoreManageVO(allotoutvo);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse<StoreManageVO> response = this.storeManageService.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
            if (!Objects.isNull((Object)allotOutEntity)) {
                com.ejianc.business.assist.store.vo.AllotOutVO vo;
                LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
                allotOutWrapper.eq(BaseEntity::getId, (Object)billId);
                allotOutWrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
                allotOutWrapper.set(AllotOutEntity::getReturnReason, null);
                allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, null);
                allotOutWrapper.set(AllotOutEntity::getReceiverPerson, null);
                this.service.update((Wrapper)allotOutWrapper);
                if ("1".equals(allotOutEntity.getInAllocaScope())) {
                    vo = (com.ejianc.business.assist.store.vo.AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), com.ejianc.business.assist.store.vo.AllotOutVO.class);
                    String msg = this.service.amCreateAllotIn(vo);
                    if (null != msg) {
                        throw new BusinessException(msg);
                    }
                } else {
                    vo = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
                    CommonResponse resp = this.allotOutApi.createAllotIn((AllotOutVO)vo);
                    if (!resp.isSuccess() && resp.getData() != null) {
                        throw new BusinessException("\u751f\u6210\u8c03\u51fa\u5355\u5931\u8d25\uff01");
                    }
                }
                CommonResponse commonResponse = CommonResponse.success();
                return commonResponse;
            }
            try {
                throw new BusinessException("\u8be5\u5355\u636e\u4e0d\u5b58\u5728\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
                CommonResponse commonResponse = CommonResponse.error((String)e.getMessage());
                return commonResponse;
            }
        }
        finally {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
            }
            jedis.close();
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOutEntity entity = (AllotOutEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == entity.getBillState() || BillStateEnum.PASSED_STATE.getBillStateCode() == entity.getBillState()) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001\u7ed9\u8c03\u5165\u65b9\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

