package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.material.bean.MaterialChangeEntity;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.consts.MaterialConstant;
import com.ejianc.business.assist.material.service.IMaterialChangeService;
import com.ejianc.business.assist.material.service.IMaterialContractFileService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.ISignatureService;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("materialSignatureService")
public class SignatureServiceImpl implements ISignatureService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IMaterialContractService contractService;

    @Autowired
    private IMaterialChangeService changeService;
    
    @Autowired
    private IMaterialContractFileService fileService;
    

    /**
     * 签章流程
     * 单据签章状态修改逻辑
     * 1.主合同若签章状态为已签章，则修改主合同签章状态和合同状态以及生效时间，否则只修改签章状态
     * 2.变更合同
     *      若签章状态为已签章则将变更信息回写主合同，生成变更记录，改变变更合同签章状态
     *      否则改变变更合同签章状态，修改主合同的变更合同签章状态
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        logger.info("进入签章状态修改流程------------->");
        // signatureStatus - 1 是因为分包的签章状态是1234，签章服务传递的参数也是固定的1234，但这边是0123，需要-1
        signatureStatus = signatureStatus - 1;
        
        if (MaterialConstant.CONTRACT_REFCODE.equals(refCode)) {//主合同
            MaterialContractEntity contractEntity = contractService.selectById(id);
            if (contractEntity != null) {
                if (signatureStatus == SignatureStatusEnum.已签章.getCode()) {
                    contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
                    contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
                } else {
                    contractEntity.setSignatureStatus(signatureStatus);
                }
                contractService.saveOrUpdate(contractEntity, false);

                if (signatureStatus == SignatureStatusEnum.已签章.getCode()) {
                    //更新合同的 签章文件id - signFieldId
                    fileService.getSignedFileInfo(id, "contract");
                }

                logger.info("主合同签章状态已修改---------------->");
            } else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        } else if (MaterialConstant.CONTRACT_REFCODE_CHANGE.equals(refCode)) {//变更合同
            MaterialChangeEntity changeEntity = changeService.selectById(id);
            if (changeEntity != null) {
                if (signatureStatus == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                    return changeService.effectiveSaveWriteContract(id, changeEntity.getBillCode(), false);
                }else {
                    changeEntity.setSignatureStatus(signatureStatus);
                    changeService.saveOrUpdate(changeEntity);
                    logger.info("变更合同签章状态已修改---------------->");
                    //回写主合同（变更合同签章状态，主合同变更状态）
                    LambdaUpdateWrapper<MaterialContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.eq(MaterialContractEntity::getId, changeEntity.getContractId());
                    updateWrapper.set(MaterialContractEntity::getChangeContractSignatureStatus, changeEntity.getSignatureStatus());
                    contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                    logger.info("签章状态为已签章，回写主合同签章状态---------------->");
                }
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else {
            return CommonResponse.error("请检查refCode值是否正确！");
        }
        return CommonResponse.success("签章状态修改成功！");
    }
}
