package com.ejianc.business.outrmat.lose.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.consts.MaterialConstant;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.mapper.OutRmatLoseMapper;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseDetailVO;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.outrmat.utils.ValidateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 遗失单
 * 
 * @author generator
 * 
 */
@Service("outRmatLoseService")
public class OutRmatLoseServiceImpl extends BaseServiceImpl<OutRmatLoseMapper, OutRmatLoseEntity> implements IOutRmatLoseService {
    @Autowired
    private IMaterialService materialService;

    @Autowired
    private PushSupUtil pushSupUtil;

    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.租出遗失单.getCode();
    private static final String BILL_NAME = BillTypeEnum.租出遗失单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/lose/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/lose/billDel";

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<OutRmatLoseEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许新增!");
        }
        return "校验通过！";
    }

    /**
     * 校验必须大于最大单据日期
     * @param  outRmatLoseVO
     * @return
     */
    @Override
    public String validateTime(OutRmatLoseVO outRmatLoseVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", outRmatLoseVO.getContractId());
        if(outRmatLoseVO.getId() != null){
            params.put("billType", MaterialConstant.遗失单);// TODO 待修改 MaterialConstant
            params.put("billId", outRmatLoseVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);
        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(outRmatLoseVO.getStopDate(), lastDate, maxTimeMap,outRmatLoseVO.getCreateTime())){
            throw new BusinessException(DateUtil.formatDate(outRmatLoseVO.getStopDate())
                    + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        for(OutRmatLoseDetailVO vo : outRmatLoseVO.getLoseDetailList()){
            if(ValidateUtil.compareDate(vo.getDate(), lastDate, maxTimeMap,vo.getCreateTime())){
                throw new BusinessException(DateUtil.formatDate(vo.getDate())
                        + "小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
            }
        }
        return "校验通过！";
    }

    @Override
    public boolean pushBillToSupCenter(OutRmatLoseEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        OutRmatLoseEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                OutRmatLoseEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(OutRmatLoseEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }
}
