package com.ejianc.business.outrmat.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.service.IDeliveryDetailService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.delivery.bean.OutRmatDeliveryDetailEntity;
import com.ejianc.business.outrmat.delivery.service.IOutRmatDeliveryDetailService;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDetailEntity;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDetailService;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outrmat.order.mapper.OutRmatOrderDeliveryMapper;
import com.ejianc.business.outrmat.order.bean.OutRmatOrderDeliveryEntity;
import com.ejianc.business.outrmat.order.service.IOutRmatOrderDeliveryService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 租出订单-发货流水表
 * 
 * @author generator
 * 
 */
@Service("outRmatOrderDeliveryService")
public class OutRmatOrderDeliveryServiceImpl extends BaseServiceImpl<OutRmatOrderDeliveryMapper, OutRmatOrderDeliveryEntity> implements IOutRmatOrderDeliveryService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRmatOrderDetailService outRmatOrderDetailService;

    @Override
    public void saveOrUpdate(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
        this.addOrderDetail(detailVOS,contractId);
    }
    @Override
    public void delete(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        this.delOrderDetail(detailVOS);
    }


    //新增回显
    public void addOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS, Long contractId) {
        Map<String,OutRmatOrderDeliveryEntity> orderDeliveryDetail = new HashMap<>();
        Map<String,OutRmatOrderDetailEntity> orderDetail = new HashMap<>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail: detailVOS) {
                List<OutRmatOrderDetailEntity> orderDetailEntities = outRmatOrderDetailService.queryMaterialDetail(contractId, outRmatDeliveryDetail.getMaterialId(), outRmatDeliveryDetail.getRentUnitId(), outRmatDeliveryDetail.getCalculateUnitId(), outRmatDeliveryDetail.getRentType().toString());//剩余发货大于0的订单明细
                BigDecimal orderNumsSum = outRmatDeliveryDetail.getRentNum() == null ? BigDecimal.ZERO : outRmatDeliveryDetail.getRentNum();//计租量
                if (CollectionUtils.isNotEmpty(orderDetailEntities)) {
                    for (int i = 0; i < orderDetailEntities.size(); i++) {
                        if (orderNumsSum.compareTo(BigDecimal.ZERO) > 0) {//总订单>0
                            BigDecimal orderNums = BigDecimal.ZERO;//本次占用
                            OutRmatOrderDetailEntity entity  = null;
                            if(orderDetail.containsKey(orderDetailEntities.get(i).getId().toString())){
                                entity= orderDetail.get(orderDetailEntities.get(i).getId().toString());
                            }else {
                                entity = orderDetailEntities.get(i);
                            }
                            OutRmatOrderDeliveryEntity orderDelivery = BeanMapper.map(entity, OutRmatOrderDeliveryEntity.class);
                            BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();// 接收数量
                            BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();// 发货数量
                            BigDecimal surplusNums = entity.getNotDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getNotDeliveredNumsSum();// 剩余发货
                            if (orderNumsSum.compareTo(surplusNums) < 0) {//总订单量小于剩余量 取总订单量
                                orderNums = orderNumsSum;
                            } else if(i==orderDetailEntities.size()-1){
                                orderNums = orderNumsSum;
                            }else {
                                orderNums = surplusNums;
                            }
                            orderDelivery.setDeliveredNumsSum(orderNums);
                            //流水赋值
                            orderDelivery.setId(IdWorker.getId());
                            orderDelivery.setOrderDetailId(entity.getId());
                            orderDelivery.setDeliveryId(outRmatDeliveryDetail.getDeliveryId());
                            orderDelivery.setDeliveryDetailId(outRmatDeliveryDetail.getId());
                            //订单赋值
                            entity.setDeliveredNumsSum(occupyNums.add(orderDelivery.getDeliveredNumsSum()));
                            entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                            orderNumsSum = orderNumsSum.subtract(orderNums);
                            orderDetail.put(entity.getId().toString(),entity);
                            orderDeliveryDetail.put(""+orderDelivery.getOrderDetailId()+orderDelivery.getDeliveryDetailId(),orderDelivery);
                        }
                    }
                }
            }
            logger.info("新增修改订单-----"+ JSONObject.toJSONString(orderDetail));
            if (MapUtils.isNotEmpty(orderDetail)){
                outRmatOrderDetailService.updateBatchById(orderDetail.values());
            }
            logger.info("新增订单出库流水-----"+JSONObject.toJSONString(orderDeliveryDetail));
            if (MapUtils.isNotEmpty(orderDeliveryDetail)){
                this.saveOrUpdateBatch(orderDeliveryDetail.values());
            }
        }
    }

    //删除回显
    public void delOrderDetail(List<OutRmatDeliveryDetailEntity> detailVOS) {
        ArrayList<OutRmatOrderDetailEntity> orderDetailList = new ArrayList<>();
        ArrayList<OutRmatOrderDeliveryEntity> orderDeliveryDetailList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutRmatDeliveryDetailEntity outRmatDeliveryDetail : detailVOS) {//遍历父级
                LambdaQueryWrapper<OutRmatOrderDeliveryEntity> lambda = Wrappers.<OutRmatOrderDeliveryEntity>lambdaQuery();
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryDetailId, outRmatDeliveryDetail.getId());
                lambda.eq(OutRmatOrderDeliveryEntity::getDeliveryId, outRmatDeliveryDetail.getDeliveryId());
                List<OutRmatOrderDeliveryEntity> list = this.list(lambda);
                if (CollectionUtils.isNotEmpty(list)) {
                    for (OutRmatOrderDeliveryEntity orderDelivery: list) {//遍历子级进行计划分摊
                        OutRmatOrderDetailEntity entity = outRmatOrderDetailService.getById(orderDelivery.getOrderDetailId());
                        BigDecimal nums = entity.getReceiveNumsSum() == null ? BigDecimal.ZERO : entity.getReceiveNumsSum();// 数量
                        BigDecimal occupyNums = entity.getDeliveredNumsSum() == null ? BigDecimal.ZERO : entity.getDeliveredNumsSum();// 占用数量
                        BigDecimal orderNums = orderDelivery.getDeliveredNumsSum() == null ? BigDecimal.ZERO : orderDelivery.getDeliveredNumsSum();//订单量
                        entity.setDeliveredNumsSum(occupyNums.subtract(orderNums));
                        entity.setNotDeliveredNumsSum(nums.subtract(entity.getDeliveredNumsSum()));
                        orderDetailList.add(entity);
                        orderDeliveryDetailList.add(orderDelivery);
                    }
                }
            }
            logger.info("删除修改订单-----"+JSONObject.toJSONString(orderDetailList));
            if(CollectionUtils.isNotEmpty(orderDetailList)){
                outRmatOrderDetailService.updateBatchById(orderDetailList);
            }
            logger.info("删除订单出库流水-----"+JSONObject.toJSONString(orderDeliveryDetailList));
            if(CollectionUtils.isNotEmpty(orderDeliveryDetailList)){
                this.removeByIds(orderDeliveryDetailList.stream().map(OutRmatOrderDeliveryEntity::getId).collect(Collectors.toList()), true);
            }
        }
    }

}
