package com.ejianc.business.assist.rmat.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.assist.rmat.bean.DeliveryEntity;
import com.ejianc.business.assist.rmat.bean.OrderEntity;
import com.ejianc.business.assist.rmat.service.IDeliveryService;
import com.ejianc.business.assist.rmat.utils.EntityUtil;
import com.ejianc.business.assist.rmat.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 周转材租赁-送货单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("delivery")
public class DeliveryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private IDeliveryService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 接收并保存私有云推送单据
     *
     * @param request
     * @return
     */
    @PostMapping(value = "billSync")
    @ResponseBody
    public CommonResponse<String> billSync(HttpServletRequest request) {
        String msg = service.saveSyncBill(request);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("单据同步成功！");
    }

    /**
     * 接受私有云单据删除通知并删除对应单据
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "billDel")
    @ResponseBody
    public CommonResponse<String> billDel(@RequestBody DeliveryVO vo) {
        DeliveryEntity entity = EntityUtil.selectOne("source_id", vo.getSourceId(), DeliveryEntity.class);
        if(entity == null){
            return CommonResponse.error("操作失败，未查到该单据！");
        }
        if(!entity.getSourceSystemId().equals(entity.getSourceSystemId())) {
            return CommonResponse.error("操作失败，单据来源系统信息不匹配！");
        }
        String msg = service.billDel(entity);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！", "操作成功！");
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
    	DeliveryEntity entity = service.selectById(id);
    	DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("firstPartyName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<DeliveryEntity> page = service.queryPage(param,false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * 供方签字确认信息回写
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/closeDelivery")
    @ResponseBody
    public CommonResponse<String> closeDelivery(Long id) {

        DeliveryEntity entity = service.selectById(id);

        if(CommonConstant.DELIVERY_ACCEPTANCE_ALL.equals(entity.getAcceptanceState())){
            return CommonResponse.error("送货单已全部验收，不能关闭！");
        }

        String msg = service.changeCloseState(entity);
        if(null!=msg){
            return CommonResponse.error(msg);
        }

        return CommonResponse.success("送货单关闭成功！");
    }

}
