package com.ejianc.business.outrmat.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractFreezeEntity;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.mapper.OutRmatContractFreezeMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractFreezeService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractFreezeVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractFreezeRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 合同冻结
 * 
 * @author generator
 * 
 */
@Service("outRmatContractFreezeService")
public class OutRmatContractFreezeServiceImpl extends BaseServiceImpl<OutRmatContractFreezeMapper, OutRmatContractFreezeEntity> implements IOutRmatContractFreezeService {

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOrgApi iOrgApi;

    private static final String PRORMAT_CONTRACT_FREEZE = "PRORMAT_CONTRACT_FREEZE";//此处需要根据实际修改
    
    
    @Autowired
    private IOutRmatContractService contractService;
    
    @Override
    public OutRmatContractFreezeVO saveOrUpdate(OutRmatContractFreezeVO saveOrUpdateVO) {
        OutRmatContractFreezeEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatContractFreezeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            addFreezeFlag(saveOrUpdateVO.getContractId());
            
            BillCodeParam billCodeParam = BillCodeParam.build(PRORMAT_CONTRACT_FREEZE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        contractService.validateContract(saveOrUpdateVO.getContractId(), OutRmatConstant.冻结单, saveOrUpdateVO.getId(), OutRmatConstant.保存);
        
        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, OutRmatContractFreezeVO.class);
    }

    @Override
    public Boolean addFreezeFlag(Long id) {
        LambdaQueryWrapper<OutRmatContractFreezeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatContractFreezeEntity::getContractId, id);
        wrapper.notIn(OutRmatContractFreezeEntity::getBillState, Arrays.asList(1, 3));

        List<OutRmatContractFreezeEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同下有未生效的冻结/解冻单不能再次发起冻结/解冻请求！");
        }
        
        return true;
    }

    @Override
    public OutRmatContractFreezeRecordVO queryFreezeRecord(Long id) {
        OutRmatContractEntity entity = contractService.selectById(id);
        OutRmatContractFreezeRecordVO vo = new OutRmatContractFreezeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        
        // 查询冻结单
        LambdaQueryWrapper<OutRmatContractFreezeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatContractFreezeEntity::getContractId, id);
        wrapper.orderByDesc(OutRmatContractFreezeEntity::getCreateTime);

        List<OutRmatContractFreezeEntity> list = this.list(wrapper);
        
        vo.setDetailList(BeanMapper.mapList(list, OutRmatContractFreezeVO.class));
        
        
        return vo;
    }
}
