package com.ejianc.business.assist.store.service.impl;

import com.ejianc.business.assist.store.bean.PickReturnEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.service.IPickReturnService;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.PickReturnDetailVO;
import com.ejianc.business.assist.store.vo.PickReturnVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("pickReturn")
public class PickReturnBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IPickReturnService pickReturnService;

    @Autowired
    private StoreManageService storeManageService;

    @Autowired
    private IStoreCheckService checkService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        PickReturnEntity entity = pickReturnService.selectById(billId);
        PickReturnVO pickReturnVO = BeanMapper.map(entity, PickReturnVO.class);
        if (pickReturnVO != null && pickReturnVO.getPickReturnDetailList().size() > 0) {
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                List<PickReturnDetailVO> detailVOS = detailMap.get(storeId);
                pickReturnVO.setPickReturnDetailList(detailVOS);
                StoreManageVO storeManageVO = pickReturnVO.getStoreManageVO(pickReturnVO, storeId);
                storeManageService.inOutStore(storeManageVO);
            });
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 1、需判断除本单据生成出库单之外，与该退库单相关联的入库单的入库数量大于等于对应出库单的出库数量；  如不满足条件，不可弃审；
        // 2、材料退库对应的出库单是否被成本引用，如被引用，不可弃审；
        // 2、处置时间之后有盘点单时，不可弃审
        PickReturnEntity entity = pickReturnService.selectById(billId);
        if (entity != null) {
            CommonResponse commonResponse = checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", entity.getInstoreDate()));
            return commonResponse;
        } else {
            return CommonResponse.error("单据异常，弃审失败");
        }
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

        PickReturnEntity entity = pickReturnService.selectById(billId);
        if (entity != null && entity.getPickReturnDetailList().size() > 0) {
            PickReturnVO pickReturnVO = BeanMapper.map(entity, PickReturnVO.class);
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setStoreId(storeId);
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料退库);
                storeManageService.inOutStoreRollback(storeManageVO);
            });
        }

        return CommonResponse.success();
    }

}
