/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractRelieveEntity;
import com.ejianc.business.assist.material.service.IMaterialContractRelieveService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.IRelieveSignatureService;
import com.ejianc.business.assist.material.vo.MaterialContractVO;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialRelieveSignatureService")
public class RelieveSignatureServiceImpl
implements IRelieveSignatureService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialContractRelieveService service;
    @Autowired
    private IMaterialContractService contractService;

    @Override
    public CommonResponse<String> relieveContract(Long id, Integer signatureStatus, String refCode) {
        this.logger.info("\u66f4\u65b0\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u548c\u5408\u540c\u72b6\u6001\uff0c\u5165\u53c2--id\uff1b{}\uff0csignatureStatus\uff1a{}\uff0crefCode\uff1a{}", new Object[]{id, signatureStatus, refCode});
        signatureStatus = signatureStatus - 1;
        if (Objects.equals("am_contract_relieve", refCode)) {
            MaterialContractRelieveEntity entity = (MaterialContractRelieveEntity)((Object)this.service.selectById(id));
            entity.setSignatureStatus((int)signatureStatus);
            MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (contractEntity == null) {
                throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u53ef\u4fee\u6539\u72b6\u6001\u7684\u5408\u540c\uff01");
            }
            this.logger.info("\u5373\u5c06\u4fee\u6539\u7684\u5408\u540c\u4fe1\u606f--{}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
            if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(signatureStatus) && PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
                entity.setEffectiveDate(new Date());
                contractEntity.setPerformanceStatus(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                this.contractService.saveOrUpdate((Object)contractEntity, false);
                this.logger.info("\u5408\u540c\u5df2\u4f5c\u5e9f\uff01");
                boolean pushResult = this.contractService.pushContract((MaterialContractVO)BeanMapper.map((Object)((Object)contractEntity), MaterialContractVO.class));
                if (pushResult) {
                    contractEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    contractEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
                this.contractService.saveOrUpdate((Object)contractEntity, false);
            }
            this.service.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
    }
}

