package com.ejianc.business.outrmat.settle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.RentCalculateEntity;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.IRentCalculateService;
import com.ejianc.business.assist.rmat.vo.RentCalculateVO;
import com.ejianc.business.outrmat.calculate.bean.OutRmatCalculateEntity;
import com.ejianc.business.outrmat.calculate.service.IOutRmatCalculateService;
import com.ejianc.business.outrmat.calculate.vo.OutRmatCalculateVO;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.enums.BillPushStatusEnum;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.SettleEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractSettleRecordVO;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteEntity;
import com.ejianc.business.outrmat.restitute.bean.OutRmatRestituteOtherEntity;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteOtherService;
import com.ejianc.business.outrmat.restitute.service.IOutRmatRestituteService;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteOtherVO;
import com.ejianc.business.outrmat.restitute.vo.OutRmatRestituteVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.settle.mapper.OutRmatSettleMapper;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;
import com.ejianc.business.outrmat.stop.bean.OutRmatStopEntity;
import com.ejianc.business.outrmat.utils.DateUtil;
import com.ejianc.business.outrmat.utils.PushSupUtil;
import com.ejianc.business.pro.rmat.api.IReceiptsApi;
import com.ejianc.business.pro.rmat.enums.ReceiptsEnum;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 周转材租赁结算单
 *
 * @author generator
 *
 */
@Service("outRmatSettleService")
public class OutRmatSettleServiceImpl extends BaseServiceImpl<OutRmatSettleMapper, OutRmatSettleEntity> implements IOutRmatSettleService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String ASSIST_RMAT_RENT_IN_CONTRACT_SETTLE = "FLZX_ZCJS_CODE";//此处需要根据实际修改
    private static final String OPERATE = "SETTLE_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.辅料中心租出合同结算单.getCode();
    private static final String BILL_NAME = BillTypeEnum.辅料中心租出合同结算单.getName();

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IReceiptsApi receiptsApi;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOutRmatCalculateService outRmatCalculateService;

    @Autowired
    private IOutRmatRestituteService outRmatRestituteService;

    @Autowired
    private IOutRmatRestituteOtherService outRmatRestituteOtherService;

    @Autowired
    private IOutRmatLoseService outRmatLoseService;

    @Autowired
    private IOutRmatContractService rmatContractService;
    @Autowired
    private PushSupUtil pushSupUtil;

    @Override
    public OutRmatSettleVO saveOrUpdate(OutRmatSettleVO saveOrUpdateVO) {
        OutRmatSettleEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatSettleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(ASSIST_RMAT_RENT_IN_CONTRACT_SETTLE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            // 签字状态
            entity.setSupplierSignStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }

        // 校验合同
        validateContract(entity.getContractId(), entity.getId());
        // 校验结算日期
        OutRmatSettleVO lastVo = queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null) {
            int compareDate = DateUtil.compareDate(lastVo.getSettleDate(), entity.getSettleDate());
            if (compareDate > 0) {
                throw new BusinessException("本次结算日期" + DateUtil.formatDate(entity.getSettleDate()) + "不能小于上次结算日期" + DateUtil.formatDate(lastVo.getSettleDate()));
            }
        }

        this.saveOrUpdate(entity, false);

        return BeanMapper.map(selectById(entity.getId()), OutRmatSettleVO.class);
    }
//自由态唯一校验
    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<OutRmatSettleEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的结算单，不允许新增!");
        }
        return "校验通过！";
    }
/*查询租金计算*/
    @Override
    public List<OutRmatCalculateVO> queryCalculateData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<OutRmatCalculateEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatCalculateEntity::getContractId, contractId);
        wrapper.eq(OutRmatCalculateEntity::getSettleFlag, 0);
        wrapper.in(OutRmatCalculateEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(OutRmatCalculateEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(OutRmatCalculateEntity::getRentDate, settleDate);
        }else {
            wrapper.between(OutRmatCalculateEntity::getRentDate, lastSettleDate, settleDate);
        }

        List<OutRmatCalculateEntity> list = outRmatCalculateService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, OutRmatCalculateVO.class);
        }
    }
    /*查询退赔*/
    @Override
    public List<OutRmatRestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<OutRmatRestituteEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatRestituteEntity::getContractId, contractId);
        wrapper.eq(OutRmatRestituteEntity::getSettleFlag, 0);
        wrapper.in(OutRmatRestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(OutRmatRestituteEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(OutRmatRestituteEntity::getRestituteDate, settleDate);
        }else {
            wrapper.between(OutRmatRestituteEntity::getRestituteDate, lastSettleDate, settleDate);
        }

        List<OutRmatRestituteEntity> list = outRmatRestituteService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, OutRmatRestituteVO.class);
        }
    }

    @Override
    public List<OutRmatRestituteOtherVO> queryRestituteOtherData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<OutRmatRestituteEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatRestituteEntity::getContractId, contractId);
        wrapper.eq(OutRmatRestituteEntity::getSettleFlag, 0);
        wrapper.in(OutRmatRestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(OutRmatRestituteEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(OutRmatRestituteEntity::getRestituteDate, settleDate);
        }else {
            wrapper.between(OutRmatRestituteEntity::getRestituteDate, lastSettleDate, settleDate);
        }

        List<OutRmatRestituteEntity> list = outRmatRestituteService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            List<Long> collect = list.stream().map(t -> t.getId()).collect(Collectors.toList());
            LambdaQueryWrapper<OutRmatRestituteOtherEntity> otherWrapper = new LambdaQueryWrapper<>();
            otherWrapper.in(OutRmatRestituteOtherEntity::getRestituteId, collect);
            List<OutRmatRestituteOtherEntity> list1 = outRmatRestituteOtherService.list(otherWrapper);
            if (ListUtil.isEmpty(list1)) {
                return new ArrayList<>();
            }else {
                return BeanMapper.mapList(list1, OutRmatRestituteOtherVO.class);
            }
        }
    }

    /*查询遗失*/
    @Override
    public List<OutRmatLoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<OutRmatLoseEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatLoseEntity::getContractId, contractId);
        wrapper.eq(OutRmatLoseEntity::getSettleFlag, 0);
        wrapper.in(OutRmatLoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(OutRmatLoseEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(OutRmatLoseEntity::getBillDate, settleDate);
        }else {
            wrapper.between(OutRmatLoseEntity::getBillDate, lastSettleDate, settleDate);
        }
        List<OutRmatLoseEntity> list = outRmatLoseService.list(wrapper);
        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, OutRmatLoseVO.class);
        }
    }
    /*查询上次结算信息*/
    @Override
    public OutRmatSettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper<OutRmatSettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatSettleEntity::getContractId, contractId);
        wrapper.in(OutRmatSettleEntity::getBillState, Arrays.asList(1, 3));
        if(billId != null){
            wrapper.ne(OutRmatSettleEntity::getId, billId);
        }
        wrapper.orderByDesc(OutRmatSettleEntity::getCreateTime);

        List<OutRmatSettleEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new OutRmatSettleVO();
        }else {
            return BeanMapper.map(list.get(0), OutRmatSettleVO.class);
        }

    }
/*查询结算记录*/
    @Override
    public OutRmatContractSettleRecordVO querySettleRecord(Long id) {
        OutRmatContractEntity entity = rmatContractService.selectById(id);

        OutRmatContractSettleRecordVO vo = new OutRmatContractSettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        // 查询变更记录
        LambdaQueryWrapper<OutRmatSettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatSettleEntity::getContractId, id);
        wrapper.orderByDesc(OutRmatSettleEntity::getCreateTime);
        List<OutRmatSettleEntity> settleList = super.list(wrapper);

        if (ListUtil.isNotEmpty(settleList)) {
            vo.setTotalSettleTaxMny(settleList.get(0).getTotalSettleTaxMny());
            vo.setTotalSettleMny(settleList.get(0).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalSettleTaxMny(), vo.getTotalSettleMny()), new BigDecimal("100")));
        }

        vo.setDetailList(BeanMapper.mapList(settleList, OutRmatSettleVO.class));

        return vo;
    }

    /**
     * 单据推送到供方协同服务
     * @param entity
     * @return
     */
    @Override
    public Boolean pushBillToSupCenter(OutRmatSettleEntity entity) {
        //辅料中心与项目方组织转换 复制一个新对象推送，防止后面有保存/修改操作
        OutRmatSettleEntity map = BeanMapper.map(entity, OutRmatSettleEntity.class);
        map.setOrgId(entity.getProjectDeptId());
        map.setOrgCode(entity.getProjectDeptCode());
        map.setOrgName(entity.getProjectDeptName());
        map.setParentOrgCode(entity.getProjectOrgCode());
        map.setParentOrgId(entity.getProjectOrgId());
        map.setParentOrgName(entity.getProjectOrgName());
        logger.info("推送辅料中心数据"+JSONObject.toJSONString(map)+"----"+BILL_NAME);
        CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(map), ReceiptsEnum.周转材租赁合同结算单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        return true;

    }

    /**
     * 将推送至供方的单据作废
     * @param entity
     * @return
     */
    @Override
    public Boolean delPushBill(OutRmatSettleEntity entity) {
        CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), ReceiptsEnum.周转材租赁合同结算单.getName());
        if(!response.isSuccess()){
            throw new BusinessException(response.getMsg());
        }
        return true;

    }

    @Override
    public String updateBillSupSignSyncInfo(Map<String,String> map) {
        String billId = map.get("billId");
        OutRmatSettleEntity entity = super.selectById(Long.valueOf(billId));
        String msg = pushSupUtil.updateBillSupSignSync(map, (JSONObject) JSONObject.toJSON(entity),
                OutRmatSettleEntity.class, BILL_TYPE, BILL_NAME);
        return msg;
    }
}
