package com.ejianc.business.assist.material.service;

import com.ejianc.business.assist.material.bean.MaterialOrderEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
public interface IMaterialOrderService extends IBaseService<MaterialOrderEntity> {

    /**
     * 单据推送到供方协同服务
     *
     * @param entity 待推送单据
     * @return
     */
    boolean pushBillToSupCenter(MaterialOrderEntity entity);

    /**
     * 同步单据供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param entity
     * @return
     */
    boolean delPushBill(MaterialOrderEntity entity);

    /**
     * 校验订单是否可关闭
     * @param entity
     * @return
     */
    String validateClose(MaterialOrderEntity entity);

    /**
     * 改状态
     * @param entity
     * @return
     */
    String ChangeCloseState(MaterialOrderEntity entity);

}
