package com.ejianc.business.assist.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.store.bean.StoreCheckDetailEntity;
import com.ejianc.business.assist.store.bean.StoreCheckEntity;
import com.ejianc.business.assist.store.service.IStoreCheckService;
import com.ejianc.business.assist.store.vo.StoreCheckDetailVO;
import com.ejianc.business.assist.store.vo.StoreCheckVO;
import com.ejianc.business.assist.store.vo.UseMaterialPriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 仓库盘点表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("storeCheck")
public class StoreCheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    private static final String BILL_CODE = "ASSIST_STORE_CHECK_CODE";//此处需要根据实际修改

    @Autowired
    private IStoreCheckService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StoreCheckVO> saveOrUpdate(@RequestBody StoreCheckVO saveOrUpdateVO) {

        StoreCheckEntity entity = BeanMapper.map(saveOrUpdateVO, StoreCheckEntity.class);

        if(!ListUtil.isEmpty(saveOrUpdateVO.getCheckSubList())){
            entity.setCheckSubList(BeanMapper.mapList(saveOrUpdateVO.getCheckSubList(), StoreCheckDetailEntity.class));
        }
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        CommonResponse commonResponse = service.saveCheckStore(entity);
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
//            return commonResponse;
        }
        StoreCheckVO vo = BeanMapper.map(commonResponse.getData(), StoreCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreCheckVO> queryDetail(Long id) {
    	StoreCheckEntity entity = service.selectById(id);
    	StoreCheckVO vo = BeanMapper.map(entity, StoreCheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreCheckVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (StoreCheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.myRemoveByIds(vos.stream().map(StoreCheckVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Description checkByDate 根据仓库，时间校验是否存在盘点单
     * @Param storeId
     * @Param checkDate
     */
    @RequestMapping(value = "/checkByDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse checkByDate(Long storeId,String checkDate){
        return service.checkByDate(storeId,checkDate);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StoreCheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<StoreCheckEntity> page = service.queryPage(param,false);
        IPage<StoreCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), StoreCheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "storeName", "orgName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
        }
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<StoreCheckEntity> list = service.queryList(param);
        List<StoreCheckVO> storeCheckVOVos = BeanMapper.mapList(list, StoreCheckVO.class);
        storeCheckVOVos.forEach(item->{
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", storeCheckVOVos);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }

    /**
     * 仓库盘点物资列表导出
     *
     * @param
     * @param response
     */
    @PostMapping("excelExportMaterialList")
    public void excelExportMaterialList(@RequestBody StoreCheckVO storeCheckVO, HttpServletResponse response) {
        StoreCheckEntity entity = service.selectById(storeCheckVO.getId());
        DecimalFormat df = new DecimalFormat("#,##0.00");

        Map<String, Object> beans = new HashMap();
        List<StoreCheckDetailVO> list= new ArrayList<>();
        List<StoreCheckDetailEntity> data = entity.getCheckSubList();
        if(CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                StoreCheckDetailVO vo = BeanMapper.map(item, StoreCheckDetailVO.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("checkDetailExport.xlsx", beans, response);
    }


    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StoreCheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StoreCheckEntity> page = service.queryPage(param,false);
        IPage<StoreCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StoreCheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/turnSurplusMaterialPrice", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<UseMaterialPriceVO> turnSurplusMaterialPrice(@RequestBody StoreCheckVO saveOrUpdateVO) {
        CommonResponse<UseMaterialPriceVO> commonResponse = service.turnSurplusMaterialPrice(saveOrUpdateVO);
        return commonResponse ;
    }
}
