package com.ejianc.business.assist.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.bean.RmatFlowEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.store.bean.FlowEntity;
import com.ejianc.business.assist.store.bean.ProcessEntity;
import com.ejianc.business.assist.store.bean.ProcessProductEntity;
import com.ejianc.business.assist.store.bean.ProcessRawEntity;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.service.*;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("process") 
public class ProcessBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProcessService service;

	@Autowired
	private IStoreCheckService checkService;

	@Autowired
	private StoreManageService storeManageService;

	@Autowired
	private JedisPool jedisPool;
	@Autowired
	private IFlowService flowService;
	@Autowired
	private IRmatFlowService rmatFlowService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//加锁防止生成多个原材料加工提交前进行
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateProcessIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){

			}
			else{
				return CommonResponse.success("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateProcessIn");
			}
			jedis.close();
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//出库
		ArrayList<Long> longs = new ArrayList<>();
		longs.add(billId);
		service.processInOut(longs,true);
		//入库
		ProcessEntity entity = service.selectById(billId);
		List<ProcessProductEntity> productList = new ArrayList<>();
		List<ProcessProductEntity> proceeProductList = entity.getProcessProductList();
		for (ProcessProductEntity detailEntity:proceeProductList
		) {
			if(detailEntity.getProcessNum() != null && detailEntity.getProcessNum().compareTo(BigDecimal.ZERO) > 0){
				productList.add(detailEntity);
			}
		}
		if(productList.size() > 0){
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工入库);
			ArrayList<FlowVO> flowVOS = new ArrayList<>();
			productList.forEach(item->{
				FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.原材料加工入库,0);
				flowVO.setStoreId(entity.getStoreId());
				flowVO.setStoreName(entity.getStoreName());
				flowVO.setOrgId(entity.getOrgId());
				flowVO.setOrgName(entity.getOrgName());
				flowVO.setParentOrgId(entity.getParentOrgId());
				flowVO.setParentOrgCode(entity.getParentOrgCode());
				flowVO.setParentOrgName(entity.getParentOrgName());
				flowVO.setEmployeeId(entity.getEmployeeId());
				flowVO.setEmployeeName(entity.getEmployeeName());
				flowVO.setMaterialCategoryId(item.getMaterialTypeId());
				flowVO.setMaterialCategoryName(item.getMaterialTypeName());
				flowVO.setMaterialId(item.getMaterialId());
				flowVO.setMaterialCode(item.getMaterialCode());
				flowVO.setMaterialName(item.getMaterialName());
				flowVO.setMaterialSpec(item.getSpec());
				flowVO.setMaterialUnitId(item.getUnitId());
				flowVO.setMaterialUnitName(item.getUnitName());
				flowVO.setNum(item.getProcessNum());
				flowVO.setTaxPrice(item.getTaxPrice());
				flowVO.setTaxMny(item.getTaxMny());
				flowVO.setPrice(item.getPrice());
				flowVO.setMny(item.getMny());
				flowVO.setTax(item.getTax());
				flowVO.setTaxRate(item.getTaxRate());
				flowVO.setNetMny(flowVO.getMny());
				flowVO.setNetTaxMny(flowVO.getTaxMny());
				flowVO.setPurchasePrice(flowVO.getPrice());
				flowVO.setPurchaseTaxPrice(flowVO.getTaxPrice());
				flowVO.setSourceId(entity.getId());
				flowVO.setSourceDetailId(item.getId());
				flowVO.setSourceBillCode(entity.getBillCode());
				flowVO.setSourceBillDate(entity.getProcessDate());
				flowVOS.add(flowVO);
			});
			storeManageVO.setSourceId(entity.getId());
			storeManageVO.setFlowVOList(flowVOS);
			CommonResponse<StoreManageVO> commonResponse = storeManageService.inOutStore(storeManageVO);
			if(!commonResponse.isSuccess()){
				return CommonResponse.error(commonResponse.getMsg());
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ProcessEntity processEntity = service.selectById(billId);
		String createTime = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", processEntity.getCreateTime());
		if(processEntity != null){
			CommonResponse commonResponse = checkService.checkByDate(processEntity.getStoreId(), DateFormatUtil.formatDate("yyyy-MM-dd", processEntity.getProcessDate()));
			if (!commonResponse.isSuccess()){
				return commonResponse;
			}
		}
		StoreManageVO storeManageVO = new StoreManageVO();
		List<Long> SourceIds = new ArrayList<>();
		ProcessEntity entity = service.selectById(billId);
		Boolean checkFlag = false;
		List<ProcessProductEntity> processProductList = entity.getProcessProductList();
		List<Long> inMaterialIds = processProductList.stream().map(ProcessProductEntity::getMaterialId).collect(Collectors.toList());
		for (ProcessProductEntity item: processProductList
		) {
			if(item.getProcessNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				break;
			}
		}
		if(checkFlag){
			QueryWrapper<FlowEntity> wrapper2 = new QueryWrapper<>();
			wrapper2.orderByDesc("create_time");
			wrapper2.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_OUT);
			wrapper2.in("material_id", inMaterialIds);
			wrapper2.eq("store_id", entity.getStoreId());
			wrapper2.ne("source_id", billId);
			wrapper2.apply(" (create_time > '" + createTime + "')");
			List<FlowEntity> list1 = flowService.list(wrapper2);
			if(CollectionUtils.isNotEmpty(list1)){
				return CommonResponse.error("物资已被下游引用，无法弃审！");
			}
			QueryWrapper<RmatFlowEntity> wrapper3 = new QueryWrapper<>();
			wrapper3.orderByDesc("create_time");
			wrapper3.eq("bill_type_code", BillTypeEnum.租出出库单.getCode());
			wrapper3.in("material_id", inMaterialIds);
			wrapper3.eq("store_id", entity.getStoreId());
//            wrapper3.ne("source_id", billId);
			wrapper3.apply(" (create_time > '" + createTime + "')");
			List<RmatFlowEntity> list2 = rmatFlowService.list(wrapper3);
			if(CollectionUtils.isNotEmpty(list1)){
				return CommonResponse.error("物料已被下游引用，无法弃审！");
			}
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(entity.getStoreId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工入库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()){
				return CommonResponse.error(storeManageVOCommonResponse.getMsg());
			}
		}
		List<ProcessRawEntity> processRawList = entity.getProcessRawList();
		List<Long> storeList = new ArrayList<>();
		for (ProcessRawEntity item: processRawList
		) {
			if(item.getRawNum().compareTo(BigDecimal.ZERO) > 0){
				checkFlag = true;
				storeList.add(item.getStoreId());
				//break;
			}
		}
		if(checkFlag){
			SourceIds.add(billId);
			storeManageVO.setSourceId(billId);
			storeManageVO.setStoreId(storeList.get(0));
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.原材料加工出库);
			storeManageVO.setSourceIdsForRollBack(SourceIds);
			storeManageVO.setOutEffectiveON(true);
			CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStoreRollback(storeManageVO);
			if(!storeManageVOCommonResponse.isSuccess()) return CommonResponse.error(storeManageVOCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
