/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outrmat.lose.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.IRmatFlowService;
import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.service.StoreManageService;
import com.ejianc.business.assist.store.vo.StoreManageVO;
import com.ejianc.business.outrmat.contract.service.IOutRmatMaterialService;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseDetailEntity;
import com.ejianc.business.outrmat.lose.bean.OutRmatLoseEntity;
import com.ejianc.business.outrmat.lose.service.IOutRmatLoseService;
import com.ejianc.business.outrmat.lose.vo.OutRmatLoseVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;

@Service(value="outRmatLose")
public class OutRmatLoseBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOutRmatLoseService service;
    @Autowired
    private IOutRmatMaterialService outRmatMaterialService;
    @Autowired
    private IRmatFlowService flowService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private JedisPool jedisPool;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(billId));
        entity.setSubmitTime(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(billId));
        if ("1".equals(entity.getRentType())) {
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            if (pushResult) {
                entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            } else {
                this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u5e94\u5546\u670d\u52a1\u5931\u8d25", (Object)BillTypeEnum.\u9057\u5931\u5355.getName(), (Object)billId);
                entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            }
        }
        entity.setSubmitTime(new Date());
        if (!this.flowService.insertLoseFlow(entity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        OutRmatLoseVO outRmatLoseVO = (OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class);
        List<StoreManageVO> storeManageVOList = this.service.getStoreManageVOList(outRmatLoseVO, true);
        if (CollectionUtils.isNotEmpty(storeManageVOList)) {
            this.logger.info("\u5e93\u5b58\u6240\u6709\u5165\u53c2\uff1a" + JSONObject.toJSONString(storeManageVOList));
            for (StoreManageVO storeManageVO : storeManageVOList) {
                this.logger.info("\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
                CommonResponse<StoreManageVO> response = this.storeManageService.inOutStore(storeManageVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(billId));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus())) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5df2\u7b7e\u5b57\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        this.outRmatMaterialService.validateContract(entity.getContractId(), null, null, "\u5f03\u5ba1");
        this.service.validateTime((OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class), "\u5f03\u5ba1");
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        if ("1".equals(entity.getRentType()) && BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            boolean pushResult = this.service.delPushBill(entity);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u4f5c\u5e9f\u534f\u540c\u670d\u52a1\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        entity.setSubmitTime(null);
        this.service.saveOrUpdate((Object)entity, false);
        if (!this.flowService.insertLoseFlow(entity, billTypeCode, RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        Map<Long, List<OutRmatLoseDetailEntity>> detailMap;
        OutRmatLoseEntity entity = (OutRmatLoseEntity)((Object)this.service.selectById(billId));
        OutRmatLoseVO outRmatLoseVO = (OutRmatLoseVO)BeanMapper.map((Object)((Object)entity), OutRmatLoseVO.class);
        if (CollectionUtils.isNotEmpty(entity.getLoseDetailList()) && MapUtils.isNotEmpty(detailMap = entity.getLoseDetailList().stream().filter(t -> null != t.getStoreId()).collect(Collectors.groupingBy(OutRmatLoseDetailEntity::getStoreId)))) {
            for (Long storeId : detailMap.keySet()) {
                List detailVOList = detailMap.get(storeId).stream().filter(t -> null != t.getSourceType() && 0 == t.getSourceType() && BigDecimal.ZERO.compareTo(t.getNumM()) != 0).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(detailVOList)) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(storeId);
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u51fa\u9057\u5931);
                storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(entity.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                this.logger.info("\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)storeManageVO));
                CommonResponse<StoreManageVO> response = this.storeManageService.inOutStoreRollback(storeManageVO);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        return CommonResponse.success();
    }
}

