/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.material.bean.MaterialContractEntity;
import com.ejianc.business.assist.material.bean.MaterialContractRelieveEntity;
import com.ejianc.business.assist.material.mapper.MaterialContractRelieveMapper;
import com.ejianc.business.assist.material.service.IMaterialContractRelieveService;
import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.assist.material.service.IMaterialSettleService;
import com.ejianc.business.assist.material.vo.MaterialContractRelieveVO;
import com.ejianc.business.assist.material.vo.record.MaterialRelieveRecordVO;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialContractRelieveService")
public class MaterialContractRelieveServiceImpl
extends BaseServiceImpl<MaterialContractRelieveMapper, MaterialContractRelieveEntity>
implements IMaterialContractRelieveService {
    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_RELIEVE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialContractService contractService;
    @Autowired
    private IMaterialSettleService settleService;

    @Override
    public MaterialContractRelieveVO saveOrUpdate(MaterialContractRelieveVO saveOrUpdateVO) {
        MaterialContractRelieveEntity entity = (MaterialContractRelieveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialContractRelieveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.contractService.validateContract(saveOrUpdateVO.getContractId(), "\u89e3\u9664\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity == null || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode()) || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()) || Objects.equals(contractEntity.getPerformanceStatus(), PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode())) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u6216\u5408\u540c\u72b6\u6001\u4e3a\u672a\u7b7e\u8ba2\u6216\u5df2\u7ec8\u6b62\u6216\u5df2\u4f5c\u5e9f\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)entity.getContractId()));
        List list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u6709\u4e00\u4efd\u5408\u540c\u89e3\u9664\u534f\u8bae!");
        }
        entity.setSignatureStatus(0);
        this.saveOrUpdate((Object)entity, false);
        return (MaterialContractRelieveVO)BeanMapper.map((Object)this.selectById(entity.getId()), MaterialContractRelieveVO.class);
    }

    @Override
    public MaterialRelieveRecordVO queryRelieveRecord(Long id) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.contractService.selectById(id));
        MaterialRelieveRecordVO vo = new MaterialRelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaterialContractRelieveEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, MaterialContractRelieveVO.class));
        return vo;
    }
}

