package com.ejianc.business.assist.material.controller.api;

import com.ejianc.business.assist.material.service.IMaterialContractService;
import com.ejianc.business.promaterial.pricelib.vo.PriceContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/assistRmatPurchase/")
public class AssistRmatPurchaseContractApi {

    @Autowired
    private IMaterialContractService service;

    /**
     * 查询材料采购价格库所需-辅料周转才-采购合同-数据
     * @param initFlag
     * @return
     */
    @GetMapping(value = "getPriceContractDataByAssistRmatPurchase")
    CommonResponse<List<PriceContractVO>> getPriceContractDataByAssistRmatPurchase(@RequestParam(value = "initFlag") String initFlag){
        List<PriceContractVO> priceContractList = service.queryPriceContractDataByAssistRmatPurchase(initFlag);
        return CommonResponse.success("查询材料采购价格库所需-辅料周转才-采购合同-数据结束！", priceContractList);
    }
}
