package com.ejianc.business.assist.material.service;

import com.ejianc.business.assist.material.bean.MaterialSettleEntity;
import com.ejianc.business.assist.material.vo.MaterialCheckDetailVO;
import com.ejianc.business.assist.material.vo.MaterialSettleVO;
import com.ejianc.business.assist.material.vo.record.MaterialSettleRecordVO;
import com.ejianc.business.assist.rmat.vo.report.RmatConSettleReportVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 辅料中心采购结算单
 * 
 * @author generator
 * 
 */
public interface IMaterialSettleService extends IBaseService<MaterialSettleEntity> {

    MaterialSettleVO saveOrUpdate(MaterialSettleVO saveOrUpdateVO);

    String validateContract(Long contractId, Long billId);

    MaterialSettleVO queryLastSettleTaxMny(Long contractId, Long billId);

    List<MaterialCheckDetailVO> queryCheckData(Long contractId, String lastSettleDate, String settleDate);
    
    MaterialSettleRecordVO querySettleRecord(Long id);

    Boolean pushSettleToPool(MaterialSettleVO vo);

    Boolean delSettleFromPool(Long id);

    String updateBillSupSignSyncInfo(HttpServletRequest request);

    Boolean pushBillToSupCenter(MaterialSettleEntity entity);

    Boolean delPushBill(MaterialSettleEntity entity);


    Map<String, Object> count(Map<String, Object> paramMap);

    List<RmatConSettleReportVO> pageList(Map<String, Object> paramMap);
}
