package com.ejianc.business.outrmat.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.outrmat.consts.OutRmatConstant;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractEntity;
import com.ejianc.business.outrmat.contract.bean.OutRmatContractRelieveEntity;
import com.ejianc.business.outrmat.contract.enums.BillTypeEnum;
import com.ejianc.business.outrmat.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.outrmat.contract.enums.SettleEnum;
import com.ejianc.business.outrmat.contract.enums.SignatureStatusEnum;
import com.ejianc.business.outrmat.contract.mapper.OutRmatContractRelieveMapper;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractRelieveService;
import com.ejianc.business.outrmat.contract.service.IOutRmatContractService;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRelieveVO;
import com.ejianc.business.outrmat.contract.vo.record.OutRmatContractRelieveRecordVO;
import com.ejianc.business.outrmat.settle.bean.OutRmatSettleEntity;
import com.ejianc.business.outrmat.settle.service.IOutRmatSettleService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 合同解除
 * 
 * @author generator
 * 
 */
@Service("outRmatContractRelieveService")
public class OutRmatContractRelieveServiceImpl extends BaseServiceImpl<OutRmatContractRelieveMapper, OutRmatContractRelieveEntity> implements IOutRmatContractRelieveService {

    private static final String PRORMAT_CONTRACT_RELIEVE = "PRORMAT_CONTRACT_RELIEVE";//此处需要根据实际修改

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOutRmatContractService contractService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private IOutRmatSettleService settleService;
    
    @Override
    public OutRmatContractRelieveVO saveOrUpdate(OutRmatContractRelieveVO saveOrUpdateVO) {
        OutRmatContractRelieveEntity entity = BeanMapper.map(saveOrUpdateVO, OutRmatContractRelieveEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(PRORMAT_CONTRACT_RELIEVE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        contractService.validateContract(saveOrUpdateVO.getContractId(), OutRmatConstant.解除单, saveOrUpdateVO.getId(), OutRmatConstant.保存);
        
        // 查询合同状态：不是履约中不可以解除
        OutRmatContractEntity outRmatContractEntity = contractService.selectById(entity.getContractId());
        if (outRmatContractEntity == null || Objects.equals(outRmatContractEntity.getPerformanceStatus(), PerformanceStatusEnum.已终止.getCode())
                || Objects.equals(outRmatContractEntity.getPerformanceStatus(), PerformanceStatusEnum.已作废.getCode())
                ||  Objects.equals(outRmatContractEntity.getPerformanceStatus(), PerformanceStatusEnum.未签订.getCode())) {
            throw new BusinessException("查询不到合同或合同状态为未签订或已终止或已作废！");
        }
        
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, entity.getContractId()));
        List<OutRmatContractRelieveEntity> list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("一个合同只能有一份合同解除协议!");
        }
        
        // 起草方式 1、上传解除协议，初始化签章状态为；1-未签章
        entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
        
        
        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, OutRmatContractRelieveVO.class);
    }

    @Override
    public Boolean addRelieveFlag(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        List<OutRmatContractRelieveEntity> list = this.queryList(param);
        
        return ListUtil.isEmpty(list);
    }

    @Override
    public OutRmatContractRelieveRecordVO queryRelieveRecord(Long id) {
        OutRmatContractEntity entity = contractService.selectById(id);
        OutRmatContractRelieveRecordVO vo = new OutRmatContractRelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        
        LambdaQueryWrapper<OutRmatContractRelieveEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatContractRelieveEntity::getContractId, id);
        wrapper.orderByDesc(OutRmatContractRelieveEntity::getCreateTime);

        List<OutRmatContractRelieveEntity> list = this.list(wrapper);
        
        vo.setDetailList(BeanMapper.mapList(list, OutRmatContractRelieveVO.class));
        
        return vo;
    }

    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(OutRmatContractRelieveEntity entity) {
        // 计算所有过程结算累计结算金额 
        LambdaQueryWrapper<OutRmatSettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRmatSettleEntity::getContractId, entity.getContractId());
        wrapper.eq(OutRmatSettleEntity::getSettleType, SettleEnum.过程结算.getCode());
        wrapper.in(OutRmatSettleEntity::getBillState, Arrays.asList(1,3));
        List<OutRmatSettleEntity> list = settleService.list(wrapper);

        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettleTaxMny() != null).map(OutRmatSettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettleMny() != null).map(OutRmatSettleEntity::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        OutRmatContractEntity outRmatContractEntity = contractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BillTypeEnum.辅料中心租出合同解除.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeDiv(totalSettleMny, outRmatContractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeDiv(totalSettleTaxMny, outRmatContractEntity.getContractTaxMny()));
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        totalVO.setLinkUrl(frontendBaseHost + "ejc-prormat-frontend/#/contract/relieveCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;

    }
    
}
