/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractFreezeEntity;
import com.ejianc.business.assist.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.PerformanceStatusEnum;
import com.ejianc.business.assist.rmat.enums.RmatPriceSourceTypeEnum;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.mapper.ContractMapper;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractFreezeService;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.ISettleService;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.common.util.DateUtils;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.pricelib.vo.PriceContractVO;
import com.ejianc.business.pro.rmat.enums.DraftTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT";
    private static final String PURCHASE_CONTRACT_YNJT = "RENT_CONTRACT_MATERIAL_YNJT";
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billDel";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITenderRmatApi tenderRmatApi;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IContractService service;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private ISettleService settleService;

    @Override
    public ContractVO saveOrUpdate(ContractVO saveOrUpdateVO, String authority) {
        ContractEntity contract;
        ContractEntity entity;
        CommonResponse orgResponse;
        if (saveOrUpdateVO.getOrgId() != null && (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) || StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode())) && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    saveOrUpdateVO.setParentOrgId(parentOrgVO.getId());
                    saveOrUpdateVO.setParentOrgCode(parentOrgVO.getCode());
                    saveOrUpdateVO.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                saveOrUpdateVO.setParentOrgId(saveOrUpdateVO.getOrgId());
                saveOrUpdateVO.setParentOrgCode(saveOrUpdateVO.getOrgCode());
                saveOrUpdateVO.setParentOrgName(saveOrUpdateVO.getOrgName());
            }
        }
        if ((entity = (ContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setBillCode(this.getContractBillCode(saveOrUpdateVO));
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            if (entity.getSupplementFlag() == 1) {
                Boolean flag = this.addSupplementFlag(saveOrUpdateVO.getMainContractId());
                if (!flag.booleanValue()) {
                    throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
                }
            } else {
                entity.setMainContractCreateDate(new Date());
            }
            if (entity.getTargetResultId() != null) {
                this.tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
            }
        } else {
            ContractEntity oldContractEntity = (ContractEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())) {
                this.tenderRmatApi.updateById(oldContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                this.tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
                List dailyIdsList = oldContractEntity.getDailyRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (Object dailyRentEntity : entity.getDailyRentList()) {
                    if (!dailyIdsList.contains(dailyRentEntity.getId())) continue;
                    dailyRentEntity.setRowState("del");
                }
                List monthIdsList = oldContractEntity.getMonthRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
                    if (!monthIdsList.contains(monthRentEntity.getId())) continue;
                    monthRentEntity.setRowState("del");
                }
                List numIdsList = oldContractEntity.getNumRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
                    if (!numIdsList.contains(numRentEntity.getId())) continue;
                    numRentEntity.setRowState("del");
                }
            }
        }
        if (entity.getSupplementFlag() == 1) {
            this.validateContract(saveOrUpdateVO.getMainContractId(), "\u8865\u5145\u534f\u8bae", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        }
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBaseMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
            dailyRentEntity.setSurplusCount(dailyRentEntity.getCount());
        }
        for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
            monthRentEntity.setSurplusCount(monthRentEntity.getCount());
        }
        for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
            numRentEntity.setSurplusCount(numRentEntity.getCount());
        }
        if (!(entity.getContractFileId() == null || (contract = (ContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        this.saveOrUpdate((Object)entity, false);
        ContractVO contractVO = this.queryDetail(entity.getId());
        return contractVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.selectById(id));
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        this.setRowState(vo);
        return vo;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.baseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public String delete(List<ContractVO> vos) {
        CommonResponse response;
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractVO vo : vos) {
                ExecutionVO executionVO = this.targetCost((ContractVO)BeanMapper.map((Object)this.getById(vo.getId()), ContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                ContractEntity contractEntity = (ContractEntity)((Object)this.getById(vo.getId()));
                if (null == contractEntity.getTargetResultId()) continue;
                CommonResponse tender = this.tenderRmatApi.updateById(contractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
            }
        }
        if (!(response = this.executionApi.aggDel(totalExecutionVOList)).isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
        }
        this.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}))).or(c -> (LambdaQueryWrapper)c.eq(ContractEntity::getPerformanceStatus, (Object)String.valueOf(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()))));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public SupplementRecordVO querySupplementRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.selectById(id));
        SupplementRecordVO vo = new SupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setPerformanceStatus(entity.getPerformanceStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(ContractEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(ContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(Integer.valueOf(supplementList.size()));
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getSupplementToalTaxMny(), (BigDecimal)vo.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, ContractVO.class));
        return vo;
    }

    public void setRowState(ContractVO vo) {
        if (ListUtil.isNotEmpty((List)vo.getDailyRentList())) {
            vo.getDailyRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getMonthRentList())) {
            vo.getMonthRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getNumRentList())) {
            vo.getNumRentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getRepairList())) {
            vo.getRepairList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getScrapList())) {
            vo.getScrapList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getOtherList())) {
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getPaymentList())) {
            vo.getPaymentList().forEach(e -> e.setRowState("edit"));
        }
        if (ListUtil.isNotEmpty((List)vo.getClauseList())) {
            vo.getClauseList().forEach(e -> e.setRowState("edit"));
        }
    }

    public ExecutionVO targetCost(ContractVO contractVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType("BT220210000000004");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        totalVO.setLinkUrl(frontendBaseHost + "ejc-assistrmat-frontend/#/contract/card?id=" + contractVO.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public Boolean pushBillToSupCenter(ContractEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public Boolean delPushBill(ContractEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public Boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)vo, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode());
            data.setContractProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            String cardType = vo.getAddType() == 0 ? "targetCard" : "addCard";
            String url = null;
            url = vo.getSupplementFlag() == 0 ? "/ejc-assistrmat-frontend/#/contract/contractMultiCards?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus() : "/ejc-assistrmat-frontend/#/contract/supplementCard?id=" + vo.getId() + "&supplementFlag=" + vo.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + vo.getPerformanceStatus();
            data.setPcCardUrl(url);
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)vo.getId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)vo.getId(), (Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        c2.getParams().put("signature_status", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        c1.getComplexParams().add(c2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(c1);
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam2.getComplexParams().add(c1);
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam3.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = (QueryParam)BeanMapper.map((Object)queryParam, QueryParam.class);
        QueryParam param2 = (QueryParam)BeanMapper.map((Object)queryParam2, QueryParam.class);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)queryParam3);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
            param2.getParams().put("id", new Parameter("ne", (Object)billId));
            param3.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u8865\u5145\u534f\u8bae".equals(billType) ? param : queryParam), (IBaseService)this.service);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u53d8\u66f4\u5355".equals(billType) ? param2 : queryParam2), (IBaseService)this.changeService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u89e3\u9664\u5355".equals(billType) ? param2 : queryParam2), (IBaseService)this.relieveService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)("\u51bb\u7ed3\u5355".equals(billType) ? param3 : queryParam3), (IBaseService)this.freezeService);
        List supplementList = new ArrayList();
        List changeList = new ArrayList();
        List relieveList = new ArrayList();
        List freezeList = new ArrayList();
        try {
            supplementList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractEntity.class);
            changeList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), ChangeEntity.class);
            relieveList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), ContractRelieveEntity.class);
            freezeList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), ContractFreezeEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(changeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(freezeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(relieveList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u89e3\u9664\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public Boolean delContractFromPool(Long id) {
        ContractPoolVO c = new ContractPoolVO();
        c.setSourceId(id);
        this.logger.info("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\uff01", (Object)id);
        CommonResponse delDataResp = this.contractPoolApi.deleteContract(c);
        if (delDataResp.isSuccess()) {
            return true;
        }
        this.logger.error("\u5c06\u5408\u540c-{}\u4ece\u5408\u540c\u6c60\u4e2d\u5220\u9664\u5931\u8d25, {}\uff01", (Object)id, (Object)delDataResp.getMsg());
        return false;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public List<PriceContractVO> queryPriceContractDataByAssistRmatIn(String initFlag) {
        List<ContractEntity> contractEntityList;
        this.logger.info("========================\u5468\u8f6c\u6750\u8f85\u6599\u79df\u5165\u5408\u540c\u660e\u7ec6\u63a8-\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        ArrayList<PriceContractVO> saveList = new ArrayList<PriceContractVO>();
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if ("1".equals(initFlag)) {
            Date qDate = DateUtils.calculationDay(new Date(), -1);
            outLogDate = DateUtils.transformationDefaultDate(new Date());
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            contractEntityList = ((ContractMapper)this.baseMapper).getContractListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            contractEntityList = this.service.queryList(queryParam, false);
        }
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (CollectionUtils.isEmpty((Collection)contractEntityList)) {
            return saveList;
        }
        List<Long> contractIdList = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<ContractDailyRentEntity> dailyRentList = ((ContractMapper)this.baseMapper).getContractDayDetailListByContractId(contractIdList);
        List<ContractMonthRentEntity> monthRentList = ((ContractMapper)this.baseMapper).getContractMonDetailListByContractId(contractIdList);
        List<ContractNumRentEntity> numRentList = ((ContractMapper)this.baseMapper).getContractNumDetailListByContractId(contractIdList);
        if (CollectionUtils.isEmpty(dailyRentList) && CollectionUtils.isEmpty(monthRentList) && CollectionUtils.isEmpty(numRentList)) {
            return saveList;
        }
        ArrayList materialTypeIdList = new ArrayList();
        if (CollectionUtils.isNotEmpty(dailyRentList)) {
            materialTypeIdList.addAll(dailyRentList.stream().map(ContractDailyRentEntity::getMaterialTypeId).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(monthRentList)) {
            materialTypeIdList.addAll(monthRentList.stream().map(ContractMonthRentEntity::getMaterialTypeId).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(numRentList)) {
            materialTypeIdList.addAll(numRentList.stream().map(ContractNumRentEntity::getMaterialTypeId).distinct().collect(Collectors.toList()));
        }
        CommonResponse materialResponse = this.materialApi.queryCategoryListByIds(materialTypeIdList);
        Map<Object, Object> materialCategoryMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u6750\u6599\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)materialResponse));
        if (materialResponse.isSuccess()) {
            List materialCategoryVOList = (List)materialResponse.getData();
            materialCategoryMap = materialCategoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));
        }
        List projectIdList = contractEntityList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter("in", contractIdList));
        settleParam.getParams().put("settle_type", new Parameter("eq", (Object)1));
        settleParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List settlementEntityList = this.settleService.queryList(settleParam, false);
        Map<Object, Object> settlementDateMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settlementEntityList)) {
            settlementDateMap = settlementEntityList.stream().collect(Collectors.toMap(SettleEntity::getContractId, SettleEntity::getSettleDate, (key1, key2) -> key2));
        }
        Map<Long, List<ContractDailyRentEntity>> detailDayMap = dailyRentList.stream().collect(Collectors.groupingBy(ContractDailyRentEntity::getContractId));
        Map<Long, List<ContractMonthRentEntity>> detailMonMap = monthRentList.stream().collect(Collectors.groupingBy(ContractMonthRentEntity::getContractId));
        Map<Long, List<ContractNumRentEntity>> detailNumMap = numRentList.stream().collect(Collectors.groupingBy(ContractNumRentEntity::getContractId));
        for (ContractEntity entity : contractEntityList) {
            PriceContractVO priceContractVO;
            List<ContractDailyRentEntity> dayDetailList = detailDayMap.get(entity.getId());
            List<ContractMonthRentEntity> monDetailList = detailMonMap.get(entity.getId());
            List<ContractNumRentEntity> numDetailList = detailNumMap.get(entity.getId());
            if (CollectionUtils.isEmpty(dayDetailList) && CollectionUtils.isEmpty(monDetailList) && CollectionUtils.isEmpty(numDetailList)) continue;
            if (CollectionUtils.isNotEmpty(dayDetailList)) {
                for (ContractDailyRentEntity contractDailyRentEntity : dayDetailList) {
                    if (contractDailyRentEntity.getMaterialId() == null) continue;
                    priceContractVO = (PriceContractVO)BeanMapper.map((Object)((Object)entity), PriceContractVO.class);
                    priceContractVO = this.ChangeContractDay(priceContractVO, contractDailyRentEntity);
                    priceContractVO.setRentCalculationType("0");
                    priceContractVO.setArea((String)projectAreaMap.get(entity.getProjectId()));
                    priceContractVO.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                    priceContractVO.setSourceId(entity.getId());
                    priceContractVO.setSourceType(RmatPriceSourceTypeEnum.\u8f85\u6599\u5468\u8f6c\u6750\u79df\u5165\u5408\u540c.getCode());
                    priceContractVO.setTargetResultId(entity.getTargetResultId());
                    priceContractVO.setMaterialInnerCode((String)materialCategoryMap.get(contractDailyRentEntity.getMaterialTypeId()));
                    priceContractVO.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                    saveList.add(priceContractVO);
                }
            }
            if (CollectionUtils.isNotEmpty(monDetailList)) {
                for (ContractMonthRentEntity contractMonthRentEntity : monDetailList) {
                    if (contractMonthRentEntity.getMaterialId() == null) continue;
                    priceContractVO = (PriceContractVO)BeanMapper.map((Object)((Object)entity), PriceContractVO.class);
                    priceContractVO = this.ChangeContractMon(priceContractVO, contractMonthRentEntity);
                    priceContractVO.setRentCalculationType("1");
                    priceContractVO.setArea((String)projectAreaMap.get(entity.getProjectId()));
                    priceContractVO.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                    priceContractVO.setSourceId(entity.getId());
                    priceContractVO.setSourceType(RmatPriceSourceTypeEnum.\u8f85\u6599\u5468\u8f6c\u6750\u79df\u5165\u5408\u540c.getCode());
                    priceContractVO.setTargetResultId(entity.getTargetResultId());
                    priceContractVO.setMaterialInnerCode((String)materialCategoryMap.get(contractMonthRentEntity.getMaterialTypeId()));
                    priceContractVO.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                    saveList.add(priceContractVO);
                }
            }
            if (!CollectionUtils.isNotEmpty(numDetailList)) continue;
            for (ContractNumRentEntity contractNumRentEntity : numDetailList) {
                if (contractNumRentEntity.getMaterialId() == null) continue;
                priceContractVO = (PriceContractVO)BeanMapper.map((Object)((Object)entity), PriceContractVO.class);
                priceContractVO = this.ChangeContractNum(priceContractVO, contractNumRentEntity);
                priceContractVO.setRentCalculationType("2");
                priceContractVO.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceContractVO.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceContractVO.setSourceId(entity.getId());
                priceContractVO.setSourceType(RmatPriceSourceTypeEnum.\u8f85\u6599\u5468\u8f6c\u6750\u79df\u5165\u5408\u540c.getCode());
                priceContractVO.setTargetResultId(entity.getTargetResultId());
                priceContractVO.setMaterialInnerCode((String)materialCategoryMap.get(contractNumRentEntity.getMaterialTypeId()));
                priceContractVO.setSettlementDate((Date)settlementDateMap.get(entity.getId()));
                saveList.add(priceContractVO);
            }
        }
        return saveList;
    }

    private PriceContractVO ChangeContractNum(PriceContractVO priceContractVO, ContractNumRentEntity detailEntity) {
        priceContractVO.setSourceDetailId(detailEntity.getId());
        priceContractVO.setMaterialId(detailEntity.getMaterialId());
        priceContractVO.setMaterialCode(detailEntity.getMaterialCode());
        priceContractVO.setMaterialName(detailEntity.getMaterialName());
        priceContractVO.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractVO.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractVO.setSpec(detailEntity.getSpec());
        priceContractVO.setUnitId(detailEntity.getUnitId());
        priceContractVO.setUnitName(detailEntity.getUnitName());
        priceContractVO.setContractNum(detailEntity.getCount());
        priceContractVO.setContractPrice(detailEntity.getUnitPrice());
        priceContractVO.setContractMny(detailEntity.getRentMny());
        priceContractVO.setContractTaxRate(detailEntity.getTaxRate());
        priceContractVO.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractVO.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractVO.setMemo(detailEntity.getMemo());
        priceContractVO.setOutFlag(Integer.valueOf(0));
        priceContractVO.setId(null);
        priceContractVO.setCreateTime(null);
        priceContractVO.setCreateUserCode(null);
        priceContractVO.setUpdateTime(null);
        priceContractVO.setUpdateUserCode(null);
        priceContractVO.setDr(detailEntity.getDr());
        return priceContractVO;
    }

    private PriceContractVO ChangeContractMon(PriceContractVO priceContractVO, ContractMonthRentEntity detailEntity) {
        priceContractVO.setSourceDetailId(detailEntity.getId());
        priceContractVO.setMaterialId(detailEntity.getMaterialId());
        priceContractVO.setMaterialCode(detailEntity.getMaterialCode());
        priceContractVO.setMaterialName(detailEntity.getMaterialName());
        priceContractVO.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractVO.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractVO.setSpec(detailEntity.getSpec());
        priceContractVO.setUnitId(detailEntity.getUnitId());
        priceContractVO.setUnitName(detailEntity.getUnitName());
        priceContractVO.setContractNum(detailEntity.getCount());
        priceContractVO.setContractPrice(detailEntity.getUnitPrice());
        priceContractVO.setContractMny(detailEntity.getRentMny());
        priceContractVO.setContractTaxRate(detailEntity.getTaxRate());
        priceContractVO.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractVO.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractVO.setMemo(detailEntity.getMemo());
        priceContractVO.setOutFlag(Integer.valueOf(0));
        priceContractVO.setId(null);
        priceContractVO.setCreateTime(null);
        priceContractVO.setCreateUserCode(null);
        priceContractVO.setUpdateTime(null);
        priceContractVO.setUpdateUserCode(null);
        priceContractVO.setDr(detailEntity.getDr());
        return priceContractVO;
    }

    private PriceContractVO ChangeContractDay(PriceContractVO priceContractVO, ContractDailyRentEntity detailEntity) {
        priceContractVO.setSourceDetailId(detailEntity.getId());
        priceContractVO.setMaterialId(detailEntity.getMaterialId());
        priceContractVO.setMaterialCode(detailEntity.getMaterialCode());
        priceContractVO.setMaterialName(detailEntity.getMaterialName());
        priceContractVO.setMaterialTypeId(detailEntity.getMaterialTypeId());
        priceContractVO.setMaterialTypeName(detailEntity.getMaterialTypeName());
        priceContractVO.setSpec(detailEntity.getSpec());
        priceContractVO.setUnitId(detailEntity.getUnitId());
        priceContractVO.setUnitName(detailEntity.getUnitName());
        priceContractVO.setContractNum(detailEntity.getCount());
        priceContractVO.setContractPrice(detailEntity.getUnitPrice());
        priceContractVO.setContractMny(detailEntity.getRentMny());
        priceContractVO.setContractTaxRate(detailEntity.getTaxRate());
        priceContractVO.setContractTaxMny(detailEntity.getRentTaxMny());
        priceContractVO.setContractTaxPrice(detailEntity.getUnitTaxPrice());
        priceContractVO.setMemo(detailEntity.getMemo());
        priceContractVO.setOutFlag(Integer.valueOf(0));
        priceContractVO.setId(null);
        priceContractVO.setCreateTime(null);
        priceContractVO.setCreateUserCode(null);
        priceContractVO.setUpdateTime(null);
        priceContractVO.setUpdateUserCode(null);
        priceContractVO.setDr(detailEntity.getDr());
        return priceContractVO;
    }

    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        this.logger.info("\u751f\u6210\u7f16\u7801\u89c4\u5219\uff0cGenerateBillCodeType=\uff1a{}", (Object)this.GenerateBillCodeType);
        if (Objects.equals(contractVo.getSupplementFlag(), ContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ContractEntity::getMainContractId, (Object)contractVo.getMainContractId());
            wrapper.in(ContractEntity::getBillState, Arrays.asList(1, 3));
            List list = this.list((Wrapper)wrapper);
            String supplementNum = "";
            supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
            contractBillCode = contractVo.getMainContractCode() + "-2-" + supplementNum;
        } else {
            switch (this.GenerateBillCodeType) {
                case "common": {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        contractBillCode = (String)billCode.getData();
                        break;
                    }
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                case "ynjt": {
                    BillCodeParam billCodeParamYnjt = BillCodeParam.build((String)PURCHASE_CONTRACT_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                    CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(billCodeParamYnjt);
                    if (!billCodeFirstPart.isSuccess()) {
                        this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                    CommonSNVO commonSNVO = new CommonSNVO();
                    commonSNVO.setSnLength(Integer.valueOf(4));
                    commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                    commonSNVO.setDimension(orgSub);
                    commonSNVO.setSourceType("YNJTCLCG");
                    CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                    if (!snResp.isSuccess()) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    contractBillCode = (String)billCodeFirstPart.getData() + orgSub + (String)snResp.getData();
                    break;
                }
                default: {
                    throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
                }
            }
        }
        return contractBillCode;
    }
}

