/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth;

import com.ejianc.framework.auth.FilterChainDefinitionsConfiguration;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.SpringContextTools;
import com.ejianc.framework.auth.shiro.StatelessAuthcFilter;
import com.ejianc.framework.auth.shiro.StatelessDefaultSubjectFactory;
import com.ejianc.framework.auth.shiro.StatelessRealm;
import com.ejianc.framework.auth.token.DefaultTokenProcessor;
import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.cache.redis.RedisPoolFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springside.modules.nosql.redis.pool.JedisPool;

@Configuration
@EnableConfigurationProperties(value={FilterChainDefinitionsConfiguration.class})
@ConfigurationProperties(prefix="ejc.shiro")
public class EjcAuthConfiguration {
    private int expr = 3600;
    private String sysid = "icop";
    private String loginUrl = "/sso/login";
    private String redisSessionUrl;
    private boolean sessionMutex = false;
    private String filterExcludes;
    @Autowired(required=false)
    private FilterChainDefinitionsConfiguration filterChainDefinitionsConfig;

    @Bean(value={"springContextTools"})
    public SpringContextTools getContextUtils() {
        SpringContextTools springContextTools = new SpringContextTools();
        return springContextTools;
    }

    @Bean(value={"statelessRealm"})
    public StatelessRealm getStatelessRealm() {
        StatelessRealm statelessRealm = new StatelessRealm();
        statelessRealm.setCachingEnabled(false);
        return statelessRealm;
    }

    @Bean(value={"subjectFactory"})
    public DefaultWebSubjectFactory getStatelessDefaultSubjectFactory() {
        StatelessDefaultSubjectFactory statelessDefaultSubjectFactory = new StatelessDefaultSubjectFactory();
        return statelessDefaultSubjectFactory;
    }

    @Bean(value={"webTokenProcessor"})
    public DefaultTokenProcessor getWebTokenProcessor() {
        DefaultTokenProcessor defaultTokenProcessor = new DefaultTokenProcessor();
        defaultTokenProcessor.setId("web");
        defaultTokenProcessor.setPath("/");
        defaultTokenProcessor.setExpr(this.expr);
        ArrayList<String> exactList = new ArrayList<String>();
        exactList.add("tenantid");
        exactList.add("userId");
        exactList.add("userType");
        exactList.add("typeAlias");
        defaultTokenProcessor.setExacts(exactList);
        return defaultTokenProcessor;
    }

    @Bean(value={"maTokenProcessor"})
    public DefaultTokenProcessor getMaTokenProcessor() {
        DefaultTokenProcessor defaultTokenProcessor = new DefaultTokenProcessor();
        defaultTokenProcessor.setId("ma");
        defaultTokenProcessor.setPath("/");
        defaultTokenProcessor.setExpr(-1);
        ArrayList<String> exactList = new ArrayList<String>();
        exactList.add("tenantid");
        exactList.add("userId");
        exactList.add("userType");
        exactList.add("typeAlias");
        defaultTokenProcessor.setExacts(exactList);
        return defaultTokenProcessor;
    }

    @Bean(value={"tokenFactory"})
    public TokenFactory getTokenFactory() {
        TokenFactory tokenFactory = new TokenFactory();
        ArrayList<ITokenProcessor> processList = new ArrayList<ITokenProcessor>();
        processList.add(this.getWebTokenProcessor());
        processList.add(this.getMaTokenProcessor());
        tokenFactory.setProcessors(processList);
        return tokenFactory;
    }

    @Bean(value={"sessionManager"})
    public DefaultSessionManager getDefaultSessionManager() {
        DefaultWebSessionManager defaultSessionManager = new DefaultWebSessionManager();
        defaultSessionManager.setSessionValidationSchedulerEnabled(false);
        return defaultSessionManager;
    }

    @Bean(value={"securityManager"})
    public DefaultWebSecurityManager getDefaultWebSecurityManager() {
        DefaultWebSecurityManager defaultWebSecurityManager = new DefaultWebSecurityManager();
        ArrayList<StatelessRealm> realms = new ArrayList<StatelessRealm>();
        realms.add(this.getStatelessRealm());
        defaultWebSecurityManager.setRealms(realms);
        defaultWebSecurityManager.setSubjectFactory((SubjectFactory)this.getStatelessDefaultSubjectFactory());
        defaultWebSecurityManager.setSessionManager((org.apache.shiro.session.mgt.SessionManager)this.getDefaultSessionManager());
        ((DefaultSessionStorageEvaluator)((DefaultSubjectDAO)defaultWebSecurityManager.getSubjectDAO()).getSessionStorageEvaluator()).setSessionStorageEnabled(false);
        return defaultWebSecurityManager;
    }

    @Bean
    public MethodInvokingFactoryBean getMethodInvokingFactoryBean() {
        MethodInvokingFactoryBean methodInvokingFactoryBean = new MethodInvokingFactoryBean();
        methodInvokingFactoryBean.setStaticMethod("org.apache.shiro.SecurityUtils.setSecurityManager");
        methodInvokingFactoryBean.setArguments(new Object[]{this.getDefaultWebSecurityManager()});
        return methodInvokingFactoryBean;
    }

    private StatelessAuthcFilter getStatelessAuthcFilter() {
        StatelessAuthcFilter statelessAuthcFilter = new StatelessAuthcFilter();
        statelessAuthcFilter.setSysid(this.sysid);
        statelessAuthcFilter.setLoginUrl(this.loginUrl);
        statelessAuthcFilter.setTokenFactory(this.getTokenFactory());
        return statelessAuthcFilter;
    }

    @Bean(value={"statelessAuthcFilter"})
    public FilterRegistrationBean<StatelessAuthcFilter> registrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)this.getStatelessAuthcFilter(), new ServletRegistrationBean[0]);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean getShiroFilterFactoryBean() {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)this.getDefaultWebSecurityManager());
        shiroFilterFactoryBean.setLoginUrl(this.loginUrl);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/actuator/**", "anon");
        if (StringUtils.isNotBlank((CharSequence)this.redisSessionUrl)) {
            if (this.filterChainDefinitionsConfig != null) {
                Map<String, String[]> anonMap = this.filterChainDefinitionsConfig.getFilterChainDefinitions();
                String[] anons = anonMap.get("anons");
                if (anons != null && anons.length > 0) {
                    for (String anon : anons) {
                        filterChainDefinitionMap.put(anon, "anon");
                    }
                }
                filterChainDefinitionMap.put("/**", "statelessAuthc");
            } else {
                filterChainDefinitionMap.put("/**", "statelessAuthc");
            }
        } else {
            filterChainDefinitionMap.put("/**", "anon");
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        HashMap<String, StatelessAuthcFilter> filterMap = new HashMap<String, StatelessAuthcFilter>();
        filterMap.put("statelessAuthc", this.getStatelessAuthcFilter());
        shiroFilterFactoryBean.setFilters(filterMap);
        return shiroFilterFactoryBean;
    }

    @Bean(value={"lifecycleBeanPostProcessor"})
    public static LifecycleBeanPostProcessor getLifecycleBeanPostProcessor() {
        LifecycleBeanPostProcessor lifecycleBeanPostProcessor = new LifecycleBeanPostProcessor();
        return lifecycleBeanPostProcessor;
    }

    @Bean(value={"sessionJedisPool"})
    public JedisPool getRedisPoolFactory() {
        RedisPoolFactory redisPoolFactory = new RedisPoolFactory();
        if (StringUtils.isBlank((CharSequence)this.redisSessionUrl)) {
            return redisPoolFactory.createJedisPool("direct://127.0.0.1:6379?poolSize=50&poolName=mypool");
        }
        return redisPoolFactory.createJedisPool(this.redisSessionUrl);
    }

    @Bean(value={"sessionMgr"})
    public SessionManager getSessionManager() {
        SessionManager sessionManager = new SessionManager();
        sessionManager.setSessionJedisPool(this.getRedisPoolFactory());
        sessionManager.setSessionMutex(this.sessionMutex);
        return sessionManager;
    }

    public int getExpr() {
        return this.expr;
    }

    public void setExpr(int expr) {
        this.expr = expr;
    }

    public String getSysid() {
        return this.sysid;
    }

    public void setSysid(String sysid) {
        this.sysid = sysid;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getRedisSessionUrl() {
        return this.redisSessionUrl;
    }

    public void setRedisSessionUrl(String redisSessionUrl) {
        this.redisSessionUrl = redisSessionUrl;
    }

    public boolean isSessionMutex() {
        return this.sessionMutex;
    }

    public void setSessionMutex(boolean sessionMutex) {
        this.sessionMutex = sessionMutex;
    }

    public String getFilterExcludes() {
        return this.filterExcludes;
    }

    public void setFilterExcludes(String filterExcludes) {
        this.filterExcludes = filterExcludes;
    }
}

