/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth.shiro;

import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.shiro.StatelessToken;
import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.auth.token.TokenParameter;
import java.util.ArrayList;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StatelessRealm
extends AuthorizingRealm {
    private static final Logger logger = LoggerFactory.getLogger(StatelessRealm.class);
    @Autowired
    TokenFactory tokenFactory;
    @Autowired
    private SessionManager sessionManager;

    public boolean supports(AuthenticationToken token) {
        return token instanceof StatelessToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        ArrayList roles = new ArrayList();
        info.addRoles(roles);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken atoken) throws AuthenticationException {
        StatelessToken token = (StatelessToken)atoken;
        TokenParameter tp = token.getTp();
        String uname = (String)token.getPrincipal();
        ITokenProcessor tokenProcessor = token.getTokenProcessor();
        String tokenStr = tokenProcessor.generateToken(tp);
        if (tokenStr == null || !this.sessionManager.validateOnlineSession(uname, tokenStr)) {
            logger.error("User [{}] authenticate fail in System, maybe session timeout!", (Object)uname);
            throw new AuthenticationException("User " + uname + " authenticate fail in System");
        }
        return new SimpleAuthenticationInfo((Object)uname, (Object)tokenStr, this.getName());
    }
}

