/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth.token;

import com.ejianc.framework.auth.security.esapi.EncryptException;
import com.ejianc.framework.auth.security.esapi.ICOPESAPI;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.auth.token.TokenInfo;
import com.ejianc.framework.auth.token.TokenParameter;
import com.ejianc.framework.core.util.CookieUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTokenProcessor
implements ITokenProcessor {
    private static Logger log = LoggerFactory.getLogger(DefaultTokenProcessor.class);
    private static int HTTPVERSION = 3;
    private String id;
    private String domain;
    private String path = "/";
    private Integer expr;
    private int hashIterations = 2;
    @Autowired
    private SessionManager sessionManager;
    private List<String> exacts = new ArrayList<String>();

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Integer getExpr() {
        return this.expr;
    }

    public void setExpr(Integer expr) {
        this.expr = expr;
    }

    public void setExacts(List<String> exacts) {
        this.exacts = exacts;
    }

    public int getHashIterations() {
        return this.hashIterations;
    }

    public void setHashIterations(int hashIterations) {
        this.hashIterations = hashIterations;
    }

    @Override
    public String generateToken(TokenParameter tp) {
        try {
            String seed = this.sessionManager.findSeed();
            String token = ICOPESAPI.encryptor().hash(this.id + tp.getUserid() + tp.getLogints() + this.getSummary(tp) + this.getExpr(), seed, this.getHashIterations());
            token = this.id + "," + this.getExpr() + "," + token;
            return Base64.encodeBase64URLSafeString((byte[])StringUtils.getBytesUtf8((String)token));
        }
        catch (EncryptException e) {
            log.error("TokenParameter is not validate!", (Throwable)e);
            throw new IllegalArgumentException("TokenParameter is not validate!");
        }
    }

    @Override
    public Cookie[] getCookieFromTokenParameter(TokenParameter tp) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        String tokenStr = this.generateToken(tp);
        Cookie token = new Cookie("token", tokenStr);
        if (HTTPVERSION == 3) {
            token.setHttpOnly(true);
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
            token.setDomain(this.domain);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)tp.getCookiePath())) {
            token.setPath(tp.getCookiePath());
        } else {
            token.setPath(this.path);
        }
        token.setMaxAge(-1);
        cookies.add(token);
        try {
            Cookie userid = new Cookie("u_usercode", URLEncoder.encode(tp.getUserid(), "UTF-8"));
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
                userid.setDomain(this.domain);
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)tp.getCookiePath())) {
                userid.setPath(tp.getCookiePath());
            } else {
                userid.setPath(this.path);
            }
            userid.setMaxAge(-1);
            cookies.add(userid);
            Cookie logints = new Cookie("u_logints", URLEncoder.encode(tp.getLogints(), "UTF-8"));
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
                logints.setDomain(this.domain);
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)tp.getCookiePath())) {
                logints.setPath(tp.getCookiePath());
            } else {
                logints.setPath(this.path);
            }
            logints.setMaxAge(-1);
            cookies.add(logints);
        }
        catch (UnsupportedEncodingException e) {
            log.error("encode error!", (Throwable)e);
        }
        if (!tp.getExt().isEmpty()) {
            for (Map.Entry<String, String> i : tp.getExt().entrySet()) {
                Cookie ext = new Cookie(i.getKey(), i.getValue());
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
                    ext.setDomain(this.domain);
                }
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)tp.getCookiePath())) {
                    ext.setPath(tp.getCookiePath());
                } else {
                    ext.setPath(this.path);
                }
                ext.setMaxAge(-1);
                cookies.add(ext);
            }
        }
        this.sessionManager.registOnlineSession(tp.getUserid(), tp.getUserContext(), tokenStr, this);
        return cookies.toArray(new Cookie[0]);
    }

    @Override
    public TokenParameter getTokenParameterFromCookie(Cookie[] cookies) {
        TokenParameter tp = new TokenParameter();
        String token = CookieUtil.findCookieValue((Cookie[])cookies, (String)"token");
        TokenInfo ti = TokenFactory.getTokenInfo(token);
        if (ti.getIntegerExpr().intValue() != this.getExpr().intValue()) {
            throw new IllegalArgumentException("illegal token!");
        }
        String userid = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_usercode");
        tp.setUserid(userid);
        String logints = CookieUtil.findCookieValue((Cookie[])cookies, (String)"u_logints");
        tp.setLogints(logints);
        if (this.exacts != null && !this.exacts.isEmpty()) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                String name = cookie.getName();
                if (!this.exacts.contains(name)) continue;
                tp.getExt().put(name, cookie.getValue());
            }
        }
        return tp;
    }

    protected String getSummary(TokenParameter tp) {
        if (this.exacts != null && !this.exacts.isEmpty()) {
            int len = this.exacts.size();
            Object[] exa = new String[len];
            for (int i = 0; i < len; ++i) {
                String name = this.exacts.get(i);
                if (i == -1) continue;
                exa[i] = tp.getExt().get(name);
            }
            return org.apache.commons.lang.StringUtils.join((Object[])exa, (String)"#");
        }
        return "";
    }

    @Override
    public Cookie[] getLogoutCookie(String tokenStr, String uid) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Cookie token = new Cookie("token", null);
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
            token.setDomain(this.domain);
        }
        token.setPath(this.path);
        cookies.add(token);
        Cookie userid = new Cookie("u_usercode", null);
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
            userid.setDomain(this.domain);
        }
        userid.setPath(this.path);
        cookies.add(userid);
        Cookie logints = new Cookie("u_logints", null);
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
            logints.setDomain(this.domain);
        }
        logints.setPath(this.path);
        cookies.add(logints);
        for (String exact : this.exacts) {
            Cookie ext = new Cookie(exact, null);
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.domain)) {
                ext.setDomain(this.domain);
            }
            ext.setPath(this.path);
            cookies.add(ext);
        }
        this.sessionManager.delOnlineSession(uid, tokenStr);
        return cookies.toArray(new Cookie[0]);
    }

    static {
        URL res = DefaultTokenProcessor.class.getClassLoader().getResource("javax/servlet/annotation/WebServlet.class");
        if (res == null) {
            HTTPVERSION = 2;
        }
    }
}

