/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth.shiro;

import com.alibaba.fastjson.JSON;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.shiro.StatelessToken;
import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.auth.token.TokenParameter;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StatelessRealm
extends AuthorizingRealm {
    private static final Logger logger = LoggerFactory.getLogger(StatelessRealm.class);
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    TokenFactory tokenFactory;
    @Autowired
    private SessionManager sessionManager;

    public boolean supports(AuthenticationToken token) {
        return token instanceof StatelessToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        ArrayList roles = new ArrayList();
        info.addRoles(roles);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken atoken) throws AuthenticationException {
        StatelessToken token = (StatelessToken)atoken;
        TokenParameter tp = token.getTp();
        String uname = (String)token.getPrincipal();
        ITokenProcessor tokenProcessor = token.getTokenProcessor();
        String tokenStr = tokenProcessor.generateToken(tp);
        if (tokenStr == null || !this.sessionManager.validateOnlineSession(uname, tokenStr)) {
            if (StringUtils.isNotBlank((CharSequence)this.baseHost) && StringUtils.isNotBlank((CharSequence)tokenStr)) {
                String url = this.baseHost + "ejc-webpush/event/send";
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("token", tokenStr);
                paramMap.put("type", "logout");
                paramMap.put("value", "logout");
                try {
                    logger.info("url\uff1a" + url);
                    logger.info("\u53c2\u6570\uff1a" + JSON.toJSONString(paramMap));
                    HttpTookit.postByJson((String)url, (String)JSON.toJSONString(paramMap));
                }
                catch (Exception e) {
                    logger.error("\u5411webpush\u53d1\u9001\u9000\u51fa\u4e8b\u4ef6\u5931\u8d25\uff1bMsg\uff1a" + e.getMessage());
                }
            }
            logger.error("User [{}] authenticate fail in System, maybe session timeout!", (Object)uname);
            throw new AuthenticationException("User " + uname + " authenticate fail in System");
        }
        return new SimpleAuthenticationInfo((Object)uname, (Object)tokenStr, this.getName());
    }
}

