/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.auth.session;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.auth.security.esapi.EncryptException;
import com.ejianc.framework.auth.security.utils.TokenGenerator;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.auth.token.ITokenProcessor;
import com.ejianc.framework.auth.token.TokenFactory;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class SessionManager {
    public static final String TOKEN_SEED = "token_seed";
    public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String localSeedValue = null;
    private JedisPool sessionJedisPool;
    @Autowired
    private EnvironmentTools environmentTools;
    private boolean sessionMutex = false;

    public JedisPool getSessionJedisPool() {
        return this.sessionJedisPool;
    }

    public void setSessionJedisPool(JedisPool sessionJedisPool) {
        this.sessionJedisPool = sessionJedisPool;
    }

    public boolean isSessionMutex() {
        return this.sessionMutex;
    }

    public void setSessionMutex(boolean sessionMutex) {
        this.sessionMutex = sessionMutex;
    }

    public String findSeed() throws EncryptException {
        if (localSeedValue != null) {
            return localSeedValue;
        }
        String seed = this.getSeedValue(TOKEN_SEED);
        if (StringUtils.isBlank((String)seed)) {
            localSeedValue = seed = TokenGenerator.genSeed();
            this.set(TOKEN_SEED, seed);
        }
        return seed;
    }

    public String getSeedValue(String key) {
        return this.get(key);
    }

    public void removeSessionCache(String sid) {
        this.del(sid);
    }

    public void putSessionCacheAttribute(String sid, String key, String value) {
        this.sessionHset(sid, key, value);
    }

    public String getSessionCacheAttribute(String sid, String key) {
        return this.sessionHget(sid, key);
    }

    private int getTimeout(String sid) {
        return TokenFactory.getTokenInfo(sid).getIntegerExpr();
    }

    public void registOnlineSession(String userid, String userContext, String token, ITokenProcessor processor) {
        String key = SESSION_PREFIX + userid;
        this.logger.debug("token processor id is {},key is {} !", (Object)processor.getId(), (Object)key);
        boolean mutex = this.isSessionMutex();
        if (mutex) {
            this.deleteUserSession(userid);
        } else {
            this.clearOnlineSession(key);
        }
        String currentTs = String.valueOf(System.currentTimeMillis());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userContext)) {
            JSONObject contextObject = JSONObject.parseObject((String)userContext);
            contextObject.put("currentTs", (Object)currentTs);
            this.sessionHset(key, token, contextObject.toJSONString());
        } else {
            JSONObject contextObject = new JSONObject();
            contextObject.put("currentTs", (Object)currentTs);
            this.sessionHset(key, token, contextObject.toJSONString());
        }
    }

    public Map<String, String> getUserSessionMap(Long userId) {
        return this.getMap(SESSION_PREFIX + userId);
    }

    public void clearOnlineSession(final String key) {
        final ArrayList<String> deleteKeys = new ArrayList<String>();
        Map<String, String> userSessions = this.getMap(key);
        if (userSessions != null) {
            for (Map.Entry<String, String> entry : userSessions.entrySet()) {
                String t = entry.getKey();
                String v = entry.getValue();
                JSONObject userContextObject = JSONObject.parseObject((String)v);
                if (userContextObject == null) continue;
                String lastTsStr = userContextObject.getString("currentTs");
                long exprMillis = this.getTimeout(t) * 1000;
                if (exprMillis <= 0L) continue;
                long cts = System.currentTimeMillis();
                if (Long.parseLong(lastTsStr) + exprMillis >= cts) continue;
                deleteKeys.add(t);
            }
        }
        JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                for (int i = 0; i < deleteKeys.size(); ++i) {
                    pipeline.hdel(key, new String[]{(String)deleteKeys.get(i)});
                }
            }
        };
        this.execute(action);
    }

    public boolean validateOnlineSession(String userid, final String token) {
        boolean result = false;
        final String key = SESSION_PREFIX + userid;
        String userContextStr = this.sessionHget(key, token);
        final boolean mutex = this.isSessionMutex();
        if (userContextStr != null) {
            final JSONObject userContextObject = JSONObject.parseObject((String)userContextStr);
            final String lastTsStr = userContextObject.getString("currentTs");
            final String customerChannel = userContextObject.getString("customerChannel");
            final int timeOut = this.getTimeout(token);
            if (timeOut <= 0) {
                return true;
            }
            final ArrayList pipelineResult = new ArrayList();
            JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

                public void action(Pipeline pipeline) {
                    long exprMillis = timeOut * 1000;
                    if (exprMillis > 0L) {
                        long cts = System.currentTimeMillis();
                        if ("dingding_channel".equals(customerChannel) || "weixinee_channel".equals(customerChannel) || mutex) {
                            userContextObject.put("currentTs", (Object)cts);
                            pipeline.hset(key, token, userContextObject.toJSONString());
                            pipeline.expire(token, timeOut);
                            pipelineResult.add(true);
                        } else if (Long.parseLong(lastTsStr) + exprMillis >= cts) {
                            userContextObject.put("currentTs", (Object)cts);
                            pipeline.hset(key, token, userContextObject.toJSONString());
                            pipeline.expire(token, timeOut);
                            pipelineResult.add(true);
                        } else {
                            pipeline.hdel(key, new String[]{token});
                        }
                    }
                }
            };
            this.execute(action);
            result = pipelineResult.size() > 0;
        }
        return result;
    }

    public void delOnlineSession(String userid, final String token) {
        final String key = SESSION_PREFIX + userid;
        JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

            public void action(Pipeline pipeline) {
                pipeline.del(token);
                pipeline.hdel(key, new String[]{token});
            }
        };
        this.execute(action);
    }

    public void deleteUserSession(String userid) {
        String key;
        Map<String, String> userSessions;
        boolean isMobile = true;
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            isMobile = SessionManager.isPadDevice(request);
        }
        catch (Exception request) {
            // empty catch block
        }
        if (!isMobile && (userSessions = this.getMap(key = SESSION_PREFIX + userid)) != null) {
            final ArrayList tokenList = new ArrayList();
            JedisTemplate.PipelineActionNoResult action = new JedisTemplate.PipelineActionNoResult(){

                public void action(Pipeline pipeline) {
                    for (Map.Entry entry : userSessions.entrySet()) {
                        String t = (String)entry.getKey();
                        tokenList.add(t);
                        pipeline.del(t);
                    }
                    pipeline.del(key);
                }
            };
            this.execute(action);
            final String baseHost = this.environmentTools.getBaseHost();
            this.logger.info("delete user session tokenList {},basehost is {} !", tokenList, (Object)baseHost);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)baseHost) && tokenList.size() > 0) {
                Thread sessionMutexThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String url = baseHost + "ejc-webpush/event/batchSend";
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("tokens", tokenList);
                        paramMap.put("type", "sessionMutex");
                        paramMap.put("value", "sessionMutex");
                        try {
                            SessionManager.this.logger.info("url\uff1a" + url);
                            SessionManager.this.logger.info("\u53c2\u6570\uff1a" + JSON.toJSONString(paramMap));
                            HttpTookit.postByJson((String)url, (String)JSON.toJSONString(paramMap));
                        }
                        catch (Exception e) {
                            SessionManager.this.logger.error("\u5411webpush\u53d1\u9001\u9000\u51fa\u4e8b\u4ef6\u5931\u8d25\uff1bMsg\uff1a" + e.getMessage());
                        }
                    }
                });
                sessionMutexThread.start();
            }
        }
    }

    public boolean validateOnlineByUserId(String userId) {
        boolean result;
        block4: {
            result = false;
            try {
                String key = SESSION_PREFIX + userId;
                Map<String, String> userSessions = this.getMap(key);
                if (userSessions.isEmpty()) break block4;
                String token = null;
                for (Map.Entry<String, String> entry : userSessions.entrySet()) {
                    long exprMillis;
                    token = entry.getKey();
                    String userContextStr = this.sessionHget(key, token);
                    if (userContextStr == null) continue;
                    JSONObject userContextObject = JSONObject.parseObject((String)userContextStr);
                    String lastTsStr = userContextObject.getString("currentTs");
                    int timeOut = this.getTimeout(token);
                    if (timeOut <= 0) {
                        result = true;
                    }
                    if ((exprMillis = (long)(timeOut * 1000)) <= 0L) continue;
                    long cts = System.currentTimeMillis();
                    if (Long.parseLong(lastTsStr) + exprMillis < cts) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    private void set(final String key, final String value) {
        this.execute(new JedisTemplate.JedisActionNoResult(){

            public void action(Jedis jedis) {
                jedis.set(key, value);
            }
        });
    }

    private String get(final String key) {
        return this.execute(new JedisTemplate.JedisAction<String>(){

            public String action(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    private void execute(JedisTemplate.JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    private <T> T execute(JedisTemplate.JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            Object object = jedisAction.action(jedis);
            return (T)object;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    private Boolean del(final String ... keys) {
        return this.execute(new JedisTemplate.JedisAction<Boolean>(){

            public Boolean action(Jedis jedis) {
                return jedis.del(keys) == (long)keys.length;
            }
        });
    }

    private void sessionHset(final String key, final String fieldName, final String value) {
        this.execute(new JedisTemplate.JedisActionNoResult(){

            public void action(Jedis jedis) {
                jedis.hset(key, fieldName, value);
            }
        });
    }

    private String sessionHget(final String key, final String fieldName) {
        return this.execute(new JedisTemplate.JedisAction<String>(){

            public String action(Jedis jedis) {
                return jedis.hget(key, fieldName);
            }
        });
    }

    private Map<String, String> getMap(final String key) {
        return this.execute(new JedisTemplate.JedisAction<Map<String, String>>(){

            public Map<String, String> action(Jedis jedis) {
                return jedis.hgetAll(key);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            this.logger.error("Redis connection " + this.getSessionJedisPool().getAddress() + " lost.", (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            this.logger.error("Redis connection " + this.getSessionJedisPool().getAddress() + " are read-only slave.", (Throwable)jedisException);
            return true;
        } else {
            this.logger.error("Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    private void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.getSessionJedisPool().returnBrokenResource(jedis);
            } else {
                this.getSessionJedisPool().returnResource(jedis);
            }
        }
        catch (Exception e) {
            this.logger.error("return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis((Jedis)jedis);
        }
    }

    private void execute(JedisTemplate.PipelineActionNoResult pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.getSessionJedisPool().getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            pipeline.sync();
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void updateUserContext(UserContext userContext) {
        String sid = SESSION_PREFIX + InvocationInfoProxy.getUserid();
        String token = InvocationInfoProxy.getToken();
        this.putSessionCacheAttribute(sid, token, JSONObject.toJSONString((Object)userContext));
    }

    public UserContext getUserContext() {
        String sid = SESSION_PREFIX + InvocationInfoProxy.getUserid();
        String userContextStr = this.getSessionCacheAttribute(sid, InvocationInfoProxy.getToken());
        UserContext userContext = (UserContext)JSONObject.parseObject((String)userContextStr, UserContext.class);
        return userContext;
    }

    public static boolean isPadDevice(HttpServletRequest request) {
        String requestHeader = request.getHeader("user-agent");
        String[] deviceArray = new String[]{"Android", "android", "mac os", "iPhone", "SymbianOS", "Windows Phone", "iPad", "iPod", "iphone", "symbianos", "windows phone", "ipad", "ipod"};
        if (requestHeader == null) {
            return false;
        }
        requestHeader = requestHeader.toLowerCase();
        for (String device : deviceArray) {
            if (requestHeader.indexOf(device) == -1) continue;
            return true;
        }
        return false;
    }
}

