package com.ejianc.framework.auth.session;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/3 每个后端工程提供获取上下文信息统一入口
 * @Description SessionController
 */

@Controller
@RequestMapping(value = "common")
public class SessionController {
    @Autowired
    SessionManager sessionMgr;

    @RequestMapping(value = "getUserContext", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserContext> getUserContext() {
        return CommonResponse.success(sessionMgr.getUserContext());
    }


}
