package com.ejianc.business.scene.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 现场监控-现场检查
 * 
 * @author generator
 * 
 */
public class CheckBfyjVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织名
    private String checkName; // 检查名称
    private Long checkType; // 检查类型
    private String checkTypeName; // 检查类型名称
    private Integer checkAttr; // 检查属性
    private String checkAttrName; // 检查属性
    private Integer checkLevel; // 检查级别1项目2公司
    private String checkId; // 检查人id
    private String checkPerson; // 检查人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检查日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reformFinishDate; // 整改完成日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 要求完成日期
    private String reformDutyId; // 整改责任人id
    private String reformDutyPerson; // 整改责任人
    private Integer reformStatus; // 整改状态
    private String reviewId; // 复查人id
    private String reviewPerson; // 复查人
    private Integer reviewItem; // 复查项
    private Integer reviewedNum; // 已复查数量
    private String notifRelevantId; // 通知相关人员id
    private String notifRelevantPerson; // 通知相关人员
    private Integer reviewStatus; // 复查状态：0-自由态，1-已提交
    private Integer overdueNum; // 逾期数量
    private String remarks; // 备注
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Integer reviewPass; // 复查合格的数量（已完成）
    private String reformName;
    private Long importTs; // 导入时间戳
    private String checkLevelName;
    private List<CheckDetailBfyjVO> sceneCheckDetails = new ArrayList<>(); // 现场监控-现场检查-检查单待检复检子表
    //发送消息时用到的数量
    private Integer msgNum;
    //发送消息时用到的ID
    private Long msgId;
    //发送消息时用到的billCode
    private String msgBillCode;
    public String getBillCode() {
        return billCode;
    }

    public String getCheckLevelName() {
        return checkLevelName;
    }

    public void setCheckLevelName(String checkLevelName) {
        this.checkLevelName = checkLevelName;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    public String getReformName() {
        return reformName;
    }

    public void setReformName(String reformName) {
        this.reformName = reformName;
    }

    public Integer getMsgNum() {
        return msgNum;
    }

    public void setMsgNum(Integer msgNum) {
        this.msgNum = msgNum;
    }

    public Long getMsgId() {
        return msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getMsgBillCode() {
        return msgBillCode;
    }

    public void setMsgBillCode(String msgBillCode) {
        this.msgBillCode = msgBillCode;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getCheckName() {
        return checkName;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCheckType() {
        return checkType;
    }
    @ReferDeserialTransfer
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }
    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    public Integer getCheckAttr() {
        return checkAttr;
    }

    public void setCheckAttr(Integer checkAttr) {
        this.checkAttr = checkAttr;
    }
    public String getCheckAttrName() {
        return checkAttrName;
    }

    public void setCheckAttrName(String checkAttrName) {
        this.checkAttrName = checkAttrName;
    }
    public Integer getCheckLevel() {
        return checkLevel;
    }

    public void setCheckLevel(Integer checkLevel) {
        this.checkLevel = checkLevel;
    }
    /**
     * 检查人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public String getCheckId() {
        return checkId;
    }

    /**
     * 检查人id
     */
    @ReferDeserialTransfer
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    public String getCheckPerson() {
        return checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getReformFinishDate() {
        return reformFinishDate;
    }

    public void setReformFinishDate(Date reformFinishDate) {
        this.reformFinishDate = reformFinishDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    /**
     * 整改责任人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public String getReformDutyId() {
        return reformDutyId;
    }

    /**
     * 整改责任人id
     */
    @ReferDeserialTransfer
    public void setReformDutyId(String reformDutyId) {
        this.reformDutyId = reformDutyId;
    }
    public String getReformDutyPerson() {
        return reformDutyPerson;
    }

    public void setReformDutyPerson(String reformDutyPerson) {
        this.reformDutyPerson = reformDutyPerson;
    }
    public Integer getReformStatus() {
        return reformStatus;
    }

    public void setReformStatus(Integer reformStatus) {
        this.reformStatus = reformStatus;
    }
    /**
     * 复查人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public String getReviewId() {
        return reviewId;
    }

    /**
     * 复查人id
     */
    @ReferDeserialTransfer
    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }
    public String getReviewPerson() {
        return reviewPerson;
    }

    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }
    public Integer getReviewItem() {
        return reviewItem;
    }

    public void setReviewItem(Integer reviewItem) {
        this.reviewItem = reviewItem;
    }
    public Integer getReviewedNum() {
        return reviewedNum;
    }

    public void setReviewedNum(Integer reviewedNum) {
        this.reviewedNum = reviewedNum;
    }
    /**
     * 通知相关人员id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    /**
     * 通知相关人员id
     */
    @ReferDeserialTransfer
    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }
    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }
    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }
    public Integer getOverdueNum() {
        return overdueNum;
    }

    public void setOverdueNum(Integer overdueNum) {
        this.overdueNum = overdueNum;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getReviewPass() {
        return reviewPass;
    }

    public void setReviewPass(Integer reviewPass) {
        this.reviewPass = reviewPass;
    }
    public Long getImportTs() {
        return importTs;
    }

    public void setImportTs(Long importTs) {
        this.importTs = importTs;
    }

    public List<CheckDetailBfyjVO> getSceneCheckDetails() {
        return sceneCheckDetails;
    }

    public void setSceneCheckDetails(List<CheckDetailBfyjVO> sceneCheckDetails) {
        this.sceneCheckDetails = sceneCheckDetails;
    }
}
