package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 出纳资金-账户登记
 * 
 * @author generator
 * 
 */
public class AccountRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long openAccountId; // 开户申请主键
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private String memo; // 备注
    private Long corpId; // 公司名称id
    private String corpCode; // 公司编码
    private String corpName; // 公司名称
    private String accountName; // 账户名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date accountTime; // 开户时间
    private String legalPerson; // 法人
    private Long accountXzId; // 账户性质
    private String accountXzName; // 账户性质名称
    private String bankAccount; // 银行账号
    private String bankName; // 开户行
    private Long commitUserId; // 提交UK
    private String commitUserName; // 提交UK名称
    private Long approveUserId; // 审核UK
    private String approveUserName; // 审核UK名称
    private String reconciliationName; // 对账人名称
    private String reconciliationType; // 对账方式
    private String reconciliationTime; // 对账时间
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目所属组织
    private String parentOrgCode; // 项目所属组织编码
    private String parentOrgName; // 项目所属组织名称
    private Long accountantId; // 项目会计
    private String accountantName; // 项目会计名称
    private Long managerId; // 业务经理
    private String managerName; // 业务经理名称
    private Integer accountStatus; // 账户状态：1-在用 2-销户
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date unAccountTime; // 销户时间
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    

    public Long getOpenAccountId() {
        return openAccountId;
    }

    public void setOpenAccountId(Long openAccountId) {
        this.openAccountId = openAccountId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getCorpId() {
        return corpId;
    }
    @ReferDeserialTransfer
    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public Date getAccountTime() {
        return accountTime;
    }

    public void setAccountTime(Date accountTime) {
        this.accountTime = accountTime;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getAccountXzId() {
        return accountXzId;
    }
    @ReferDeserialTransfer
    public void setAccountXzId(Long accountXzId) {
        this.accountXzId = accountXzId;
    }
    public String getAccountXzName() {
        return accountXzName;
    }

    public void setAccountXzName(String accountXzName) {
        this.accountXzName = accountXzName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCommitUserId() {
        return commitUserId;
    }
    @ReferDeserialTransfer
    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApproveUserId() {
        return approveUserId;
    }
    @ReferDeserialTransfer
    public void setApproveUserId(Long approveUserId) {
        this.approveUserId = approveUserId;
    }
    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName;
    }
    public String getReconciliationName() {
        return reconciliationName;
    }

    public void setReconciliationName(String reconciliationName) {
        this.reconciliationName = reconciliationName;
    }
    public String getReconciliationType() {
        return reconciliationType;
    }

    public void setReconciliationType(String reconciliationType) {
        this.reconciliationType = reconciliationType;
    }
    public String getReconciliationTime() {
        return reconciliationTime;
    }

    public void setReconciliationTime(String reconciliationTime) {
        this.reconciliationTime = reconciliationTime;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getAccountantId() {
        return accountantId;
    }

    public void setAccountantId(Long accountantId) {
        this.accountantId = accountantId;
    }
    public String getAccountantName() {
        return accountantName;
    }

    public void setAccountantName(String accountantName) {
        this.accountantName = accountantName;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public Integer getAccountStatus() {
        return accountStatus;
    }

    public void setAccountStatus(Integer accountStatus) {
        this.accountStatus = accountStatus;
    }
    public Date getUnAccountTime() {
        return unAccountTime;
    }

    public void setUnAccountTime(Date unAccountTime) {
        this.unAccountTime = unAccountTime;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
