package com.ejianc.business.scene.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 现场监控-现场检查-检查单待检复检子表
 * 
 * @author generator
 * 
 */
public class CheckDetailBfyjVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 检查单id
    private String billCode; // 检查项编号
    private String checkName; // 检查名称(来源检查单)
    private String projectName; // 项目名
    private Long checkType; // 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
    private String checkTypeName; // 
    private Integer checkAttr; // 检查属性
    private String checkAttrName; // 检查属性
    private Integer checkLevel; // 检查级别1项目2公司
    private Long checkCategoryId; // 检查项分类ID
    private String checkCategory; // 检查项分类
    private Long checkItemId; // 检查项id
    private String checkItem; // 检查项
    private String problemImgIds; // 问题照片ids
    private String problemImgUrl; // 问题照片
    private Long dangerLevel; // 隐患等级  0、一般；1、严重；2、紧急
    private String checkId; // 检查人id
    private String checkPerson; // 检查人
    private String reviewId; // 复查人 id
    private String reviewPerson; // 复查人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检查日期
    private Long currentRectificationId; // 当前整改人id
    private String currentRectificationPerson; // 当前整改人
    private String rectificationId; // 整改人id
    private String rectificationPerson; // 整改人
    private Integer isOverdue; // 是否逾期 1:是，0：否)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 要求完成日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reformDate; // 整改日期
    private String reformImgIds; // 整改照片ids
    private String reformImgUrl; // 整改照片
    private Integer reformNumber; // 整改次数
    private Integer reviewResult; // 0、待复查；1、合格；2、不合格；默认为待复查，
    private String reviewDescribe; // 复查描述
    private String reviewImgIds; // 复查图片ids
    private String reviewImgUrl; // 复查图片
    private String reformMsg; // 整改描述
    private String reformNews; // 整改信息
    private Integer isReform; // 是否整改： 1-待整改，2-已整改，3-整改不合格
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String reviewMsg; // 复查信息
    private String taskState; // 任务状态
    private Date reviewDate; // 复查时间
    private Integer isModify; // 是否支持修改 0 支持 1 不支持
    private String actualReviewer; // 实际复查人
    private String baseImgUrl;
    private String part; // 部位
    private String memo; // 备注
    private List<CheckRecordBfyjVO> sceneCheckRecords = new ArrayList<>();//整改复查记录表

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCheckName() {
        return checkName;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getCheckType() {
        return checkType;
    }

    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }
    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    public Integer getCheckAttr() {
        return checkAttr;
    }

    public void setCheckAttr(Integer checkAttr) {
        this.checkAttr = checkAttr;
    }
    public String getCheckAttrName() {
        return checkAttrName;
    }

    public void setCheckAttrName(String checkAttrName) {
        this.checkAttrName = checkAttrName;
    }
    public Integer getCheckLevel() {
        return checkLevel;
    }

    public void setCheckLevel(Integer checkLevel) {
        this.checkLevel = checkLevel;
    }
    public Long getCheckCategoryId() {
        return checkCategoryId;
    }

    public void setCheckCategoryId(Long checkCategoryId) {
        this.checkCategoryId = checkCategoryId;
    }
    public String getCheckCategory() {
        return checkCategory;
    }

    public void setCheckCategory(String checkCategory) {
        this.checkCategory = checkCategory;
    }
    public Long getCheckItemId() {
        return checkItemId;
    }

    public void setCheckItemId(Long checkItemId) {
        this.checkItemId = checkItemId;
    }
    public String getCheckItem() {
        return checkItem;
    }

    public void setCheckItem(String checkItem) {
        this.checkItem = checkItem;
    }
    public String getProblemImgIds() {
        return problemImgIds;
    }

    public void setProblemImgIds(String problemImgIds) {
        this.problemImgIds = problemImgIds;
    }
    public String getProblemImgUrl() {
        return problemImgUrl;
    }

    public void setProblemImgUrl(String problemImgUrl) {
        this.problemImgUrl = problemImgUrl;
    }
    public Long getDangerLevel() {
        return dangerLevel;
    }

    public void setDangerLevel(Long dangerLevel) {
        this.dangerLevel = dangerLevel;
    }
    public String getCheckId() {
        return checkId;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    public String getCheckPerson() {
        return checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    public String getReviewId() {
        return reviewId;
    }

    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }
    public String getReviewPerson() {
        return reviewPerson;
    }

    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 当前整改人id
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCurrentRectificationId() {
        return currentRectificationId;
    }

    /**
     * 当前整改人id
     */
    @ReferDeserialTransfer
    public void setCurrentRectificationId(Long currentRectificationId) {
        this.currentRectificationId = currentRectificationId;
    }
    public String getCurrentRectificationPerson() {
        return currentRectificationPerson;
    }

    public void setCurrentRectificationPerson(String currentRectificationPerson) {
        this.currentRectificationPerson = currentRectificationPerson;
    }
    public String getRectificationId() {
        return rectificationId;
    }

    public void setRectificationId(String rectificationId) {
        this.rectificationId = rectificationId;
    }
    public String getRectificationPerson() {
        return rectificationPerson;
    }

    public void setRectificationPerson(String rectificationPerson) {
        this.rectificationPerson = rectificationPerson;
    }
    public Integer getIsOverdue() {
        return isOverdue;
    }

    public void setIsOverdue(Integer isOverdue) {
        this.isOverdue = isOverdue;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public Date getReformDate() {
        return reformDate;
    }

    public void setReformDate(Date reformDate) {
        this.reformDate = reformDate;
    }
    public String getReformImgIds() {
        return reformImgIds;
    }

    public void setReformImgIds(String reformImgIds) {
        this.reformImgIds = reformImgIds;
    }
    public String getReformImgUrl() {
        return reformImgUrl;
    }

    public void setReformImgUrl(String reformImgUrl) {
        this.reformImgUrl = reformImgUrl;
    }
    public Integer getReformNumber() {
        return reformNumber;
    }

    public void setReformNumber(Integer reformNumber) {
        this.reformNumber = reformNumber;
    }
    public Integer getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }
    public String getReviewDescribe() {
        return reviewDescribe;
    }

    public void setReviewDescribe(String reviewDescribe) {
        this.reviewDescribe = reviewDescribe;
    }
    public String getReviewImgIds() {
        return reviewImgIds;
    }

    public void setReviewImgIds(String reviewImgIds) {
        this.reviewImgIds = reviewImgIds;
    }
    public String getReviewImgUrl() {
        return reviewImgUrl;
    }

    public void setReviewImgUrl(String reviewImgUrl) {
        this.reviewImgUrl = reviewImgUrl;
    }
    public String getReformMsg() {
        return reformMsg;
    }

    public void setReformMsg(String reformMsg) {
        this.reformMsg = reformMsg;
    }
    public String getReformNews() {
        return reformNews;
    }

    public void setReformNews(String reformNews) {
        this.reformNews = reformNews;
    }
    public Integer getIsReform() {
        return isReform;
    }

    public void setIsReform(Integer isReform) {
        this.isReform = isReform;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getReviewMsg() {
        return reviewMsg;
    }

    public void setReviewMsg(String reviewMsg) {
        this.reviewMsg = reviewMsg;
    }
    public String getTaskState() {
        return taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Integer getIsModify() {
        return isModify;
    }

    public void setIsModify(Integer isModify) {
        this.isModify = isModify;
    }
    public String getActualReviewer() {
        return actualReviewer;
    }

    public void setActualReviewer(String actualReviewer) {
        this.actualReviewer = actualReviewer;
    }
    public String getPart() {
        return part;
    }

    public void setPart(String part) {
        this.part = part;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public void setSceneCheckRecords(List<CheckRecordBfyjVO> sceneCheckRecordVO, String fileServerPath) {
        for (CheckRecordBfyjVO s : sceneCheckRecordVO) {
            String imgIds = s.getImgIds();
            if (StringUtils.isNotEmpty(imgIds)) {
                String[] ids = imgIds.split(",");
                ArrayList<ImgFileVO> imgFileVOS = new ArrayList<>();
                for (int i = 0; i < ids.length; i++) {
                    String url = fileServerPath + "ejc-file-web/attachment/filePreview?fileId=" + ids[i];
                    imgFileVOS.add(new ImgFileVO(ids[i], url));
                }
                s.setImgArr(imgFileVOS);
            }

        }
        this.sceneCheckRecords = sceneCheckRecordVO;
    }

    public String getBaseImgUrl() {
        return baseImgUrl;
    }

    public void setBaseImgUrl(String baseImgUrl) {
        this.baseImgUrl = baseImgUrl;
    }

    public List<CheckRecordBfyjVO> getSceneCheckRecords() {
        return sceneCheckRecords;
    }

    public void setSceneCheckRecords(List<CheckRecordBfyjVO> sceneCheckRecords) {
        this.sceneCheckRecords = sceneCheckRecords;
    }
}
