package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 投标管理-确认标书员
 * 
 * @author generator
 * 
 */
public class BidPersonAffirmVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编码
    private Long registrationId; // 项目报名表Id
    private Long opportunityId; // 商机登记表Id
    private Long opportunityBillCode; // 商机登记单据编码
    private String engineeringName; // 工程名称
    private String memo; // 备注
    private Long bidPersonId; // 标书员id
    private String bidPersonName; // 标书员名称
    private String bidPersonCode; // 标书员编码
    private Long budgetPersonId; // 预算员id
    private String budgetPersonName; // 预算员名称
    private String budgetPersonCode; // 预算员编码
    private BigDecimal budgetFee; // 预算费用
    private Long employeeId; // 编制人id
    private String employeeName; // 编制人名称
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-projectRegistration")
    public Long getRegistrationId() {
        return registrationId;
    }
    @ReferDeserialTransfer
    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-busOpportunity")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getBidPersonId() {
        return bidPersonId;
    }
    @ReferDeserialTransfer
    public void setBidPersonId(Long bidPersonId) {
        this.bidPersonId = bidPersonId;
    }
    public String getBidPersonName() {
        return bidPersonName;
    }

    public void setBidPersonName(String bidPersonName) {
        this.bidPersonName = bidPersonName;
    }
    public String getBidPersonCode() {
        return bidPersonCode;
    }

    public void setBidPersonCode(String bidPersonCode) {
        this.bidPersonCode = bidPersonCode;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getBudgetPersonId() {
        return budgetPersonId;
    }

    @ReferDeserialTransfer
    public void setBudgetPersonId(Long budgetPersonId) {
        this.budgetPersonId = budgetPersonId;
    }
    public String getBudgetPersonName() {
        return budgetPersonName;
    }

    public void setBudgetPersonName(String budgetPersonName) {
        this.budgetPersonName = budgetPersonName;
    }
    public String getBudgetPersonCode() {
        return budgetPersonCode;
    }

    public void setBudgetPersonCode(String budgetPersonCode) {
        this.budgetPersonCode = budgetPersonCode;
    }
    public BigDecimal getBudgetFee() {
        return budgetFee;
    }

    public void setBudgetFee(BigDecimal budgetFee) {
        this.budgetFee = budgetFee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
