package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 出纳资金-出纳日报表-主表
 * 
 * @author generator
 * 
 */
public class DaypayVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 日期
    private BigDecimal startMny; // 期初金额
    private BigDecimal endMny; // 结余金额
    private List<DaypayDetailVO> daypayDetailList = new ArrayList<>(); // 出纳资金-占用资金表-子表

    public List<DaypayDetailVO> getDaypayDetailList() {
        return daypayDetailList;
    }

    public void setDaypayDetailList(List<DaypayDetailVO> daypayDetailList) {
        this.daypayDetailList = daypayDetailList;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public BigDecimal getStartMny() {
        return startMny;
    }

    public void setStartMny(BigDecimal startMny) {
        this.startMny = startMny;
    }
    public BigDecimal getEndMny() {
        return endMny;
    }

    public void setEndMny(BigDecimal endMny) {
        this.endMny = endMny;
    }
    
}
