package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 人力行政-保险缴纳申请
 * 
 * @author generator
 * 
 */
public class InsurancePaymentApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; //单据编码
    private String personType; // 类型：公司人员/其他
    private Long personId; // 人员id
    private String personName; // 人员名称
    private Integer sex; // 性别 1：男 2：女
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生年月
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 主职ID
    private String postName; // 主职
    private Long orgId; // 组织ID
    private String orgName; // 组织
    private String idCard; // 身份证号码
    private String graduateSchool; // 毕业院校
    private String major; // 所学专业
    private String idAddress; // 身份证地址
    private String nowAddress; // 现居住地址
    private String phone; // 移动电话
    private Integer rank; // 职级
    private String rankName; // 职级
    private Integer humanType; // 人员类别 1:内部2：外部
    private String humanTypeName; // 人员类别
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束时间
    private String insuredType; // 保险种类
    private String insuredTypeName; // 保险种类
    private BigDecimal insurancePaymentBaseMny; // 保险缴纳基数
    private String feesBorne; // 费用承担情况id
    private String feesBorneName; // 费用承担情况
    private BigDecimal undertakePercent; // 费用承担比例
    private BigDecimal personalPayMnyMonth; // 个人每月承担金额
    private BigDecimal recedExternalMny; // 已收外部费用
    private BigDecimal totalDeductMny; // 累计已扣
    private BigDecimal balanceMny; // 剩余金额
    private BigDecimal personTotalMnyMonth; // 月个人合计
    private BigDecimal companyTotalMnyMonth; // 月企业合计
    private BigDecimal totalMnyMonth; // 月合计
    private BigDecimal endownmentPersonPercent; // 养老保险个人比例
    private BigDecimal endownmentPersonMny; // 养老保险个人金额
    private BigDecimal endownmentCompanyPercent; // 养老保险企业比例
    private BigDecimal endownmentCompanyMny; // 养老保险企业金额
    private BigDecimal unemployeePersonPercent; // 失业保险个人比例
    private BigDecimal unemployeePersonMny; // 失业保险个人金额
    private BigDecimal unemployeeCompanyPercent; // 失业保险企业比例
    private BigDecimal unemployeeCompanyMny; // 失业保险企业金额
    private BigDecimal injuryPersonPercent; // 工伤保险个人比例
    private BigDecimal injuryPersonMny; // 工伤保险个人金额
    private BigDecimal injuryCompanyPercent; // 工伤保险企业比例
    private BigDecimal injuryCompanyMny; // 工伤保险企业金额
    private BigDecimal baseMedicalPersonPercent; // 基本医疗保险个人比例
    private BigDecimal baseMedicalPersonMny; // 基本医疗保险个人金额
    private BigDecimal baseMedicalCompanyPercent; // 基本医疗保险企业比例
    private BigDecimal baseMedicalCompanyMny; // 基本医疗保险企业金额
    private BigDecimal seriousMedicalCompanyPercent; // 大病医疗保险企业比例
    private BigDecimal seriousMedicalCompanyMny; // 大病医疗保险企业金额
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private String educated; // 最高学历
    private String applyReason; //缴纳原因


    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getPersonType() {
        return personType;
    }

    public void setPersonType(String personType) {
        this.personType = personType;
    }
    @ReferSerialTransfer(referCode = "bfyj-employee-info")
    public Long getPersonId() {
        return personId;
    }
    @ReferDeserialTransfer
    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode = "idm-post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getGraduateSchool() {
        return graduateSchool;
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getIdAddress() {
        return idAddress;
    }

    public void setIdAddress(String idAddress) {
        this.idAddress = idAddress;
    }
    public String getNowAddress() {
        return nowAddress;
    }

    public void setNowAddress(String nowAddress) {
        this.nowAddress = nowAddress;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public Integer getHumanType() {
        return humanType;
    }

    public void setHumanType(Integer humanType) {
        this.humanType = humanType;
    }
    public String getHumanTypeName() {
        return humanTypeName;
    }

    public void setHumanTypeName(String humanTypeName) {
        this.humanTypeName = humanTypeName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getInsuredType() {
        return insuredType;
    }

    public void setInsuredType(String insuredType) {
        this.insuredType = insuredType;
    }
    public String getInsuredTypeName() {
        return insuredTypeName;
    }

    public void setInsuredTypeName(String insuredTypeName) {
        this.insuredTypeName = insuredTypeName;
    }
    public BigDecimal getInsurancePaymentBaseMny() {
        return insurancePaymentBaseMny;
    }

    public void setInsurancePaymentBaseMny(BigDecimal insurancePaymentBaseMny) {
        this.insurancePaymentBaseMny = insurancePaymentBaseMny;
    }
    public String getFeesBorne() {
        return feesBorne;
    }

    public void setFeesBorne(String feesBorne) {
        this.feesBorne = feesBorne;
    }
    public String getFeesBorneName() {
        return feesBorneName;
    }

    public void setFeesBorneName(String feesBorneName) {
        this.feesBorneName = feesBorneName;
    }
    public BigDecimal getUndertakePercent() {
        return undertakePercent;
    }

    public void setUndertakePercent(BigDecimal undertakePercent) {
        this.undertakePercent = undertakePercent;
    }
    public BigDecimal getPersonalPayMnyMonth() {
        return personalPayMnyMonth;
    }

    public void setPersonalPayMnyMonth(BigDecimal personalPayMnyMonth) {
        this.personalPayMnyMonth = personalPayMnyMonth;
    }
    public BigDecimal getRecedExternalMny() {
        return recedExternalMny;
    }

    public void setRecedExternalMny(BigDecimal recedExternalMny) {
        this.recedExternalMny = recedExternalMny;
    }
    public BigDecimal getTotalDeductMny() {
        return totalDeductMny;
    }

    public void setTotalDeductMny(BigDecimal totalDeductMny) {
        this.totalDeductMny = totalDeductMny;
    }
    public BigDecimal getBalanceMny() {
        return balanceMny;
    }

    public void setBalanceMny(BigDecimal balanceMny) {
        this.balanceMny = balanceMny;
    }
    public BigDecimal getPersonTotalMnyMonth() {
        return personTotalMnyMonth;
    }

    public void setPersonTotalMnyMonth(BigDecimal personTotalMnyMonth) {
        this.personTotalMnyMonth = personTotalMnyMonth;
    }
    public BigDecimal getCompanyTotalMnyMonth() {
        return companyTotalMnyMonth;
    }

    public void setCompanyTotalMnyMonth(BigDecimal companyTotalMnyMonth) {
        this.companyTotalMnyMonth = companyTotalMnyMonth;
    }
    public BigDecimal getTotalMnyMonth() {
        return totalMnyMonth;
    }

    public void setTotalMnyMonth(BigDecimal totalMnyMonth) {
        this.totalMnyMonth = totalMnyMonth;
    }
    public BigDecimal getEndownmentPersonPercent() {
        return endownmentPersonPercent;
    }

    public void setEndownmentPersonPercent(BigDecimal endownmentPersonPercent) {
        this.endownmentPersonPercent = endownmentPersonPercent;
    }
    public BigDecimal getEndownmentPersonMny() {
        return endownmentPersonMny;
    }

    public void setEndownmentPersonMny(BigDecimal endownmentPersonMny) {
        this.endownmentPersonMny = endownmentPersonMny;
    }
    public BigDecimal getEndownmentCompanyPercent() {
        return endownmentCompanyPercent;
    }

    public void setEndownmentCompanyPercent(BigDecimal endownmentCompanyPercent) {
        this.endownmentCompanyPercent = endownmentCompanyPercent;
    }
    public BigDecimal getEndownmentCompanyMny() {
        return endownmentCompanyMny;
    }

    public void setEndownmentCompanyMny(BigDecimal endownmentCompanyMny) {
        this.endownmentCompanyMny = endownmentCompanyMny;
    }
    public BigDecimal getUnemployeePersonPercent() {
        return unemployeePersonPercent;
    }

    public void setUnemployeePersonPercent(BigDecimal unemployeePersonPercent) {
        this.unemployeePersonPercent = unemployeePersonPercent;
    }
    public BigDecimal getUnemployeePersonMny() {
        return unemployeePersonMny;
    }

    public void setUnemployeePersonMny(BigDecimal unemployeePersonMny) {
        this.unemployeePersonMny = unemployeePersonMny;
    }
    public BigDecimal getUnemployeeCompanyPercent() {
        return unemployeeCompanyPercent;
    }

    public void setUnemployeeCompanyPercent(BigDecimal unemployeeCompanyPercent) {
        this.unemployeeCompanyPercent = unemployeeCompanyPercent;
    }
    public BigDecimal getUnemployeeCompanyMny() {
        return unemployeeCompanyMny;
    }

    public void setUnemployeeCompanyMny(BigDecimal unemployeeCompanyMny) {
        this.unemployeeCompanyMny = unemployeeCompanyMny;
    }
    public BigDecimal getInjuryPersonPercent() {
        return injuryPersonPercent;
    }

    public void setInjuryPersonPercent(BigDecimal injuryPersonPercent) {
        this.injuryPersonPercent = injuryPersonPercent;
    }
    public BigDecimal getInjuryPersonMny() {
        return injuryPersonMny;
    }

    public void setInjuryPersonMny(BigDecimal injuryPersonMny) {
        this.injuryPersonMny = injuryPersonMny;
    }
    public BigDecimal getInjuryCompanyPercent() {
        return injuryCompanyPercent;
    }

    public void setInjuryCompanyPercent(BigDecimal injuryCompanyPercent) {
        this.injuryCompanyPercent = injuryCompanyPercent;
    }
    public BigDecimal getInjuryCompanyMny() {
        return injuryCompanyMny;
    }

    public void setInjuryCompanyMny(BigDecimal injuryCompanyMny) {
        this.injuryCompanyMny = injuryCompanyMny;
    }
    public BigDecimal getBaseMedicalPersonPercent() {
        return baseMedicalPersonPercent;
    }

    public void setBaseMedicalPersonPercent(BigDecimal baseMedicalPersonPercent) {
        this.baseMedicalPersonPercent = baseMedicalPersonPercent;
    }
    public BigDecimal getBaseMedicalPersonMny() {
        return baseMedicalPersonMny;
    }

    public void setBaseMedicalPersonMny(BigDecimal baseMedicalPersonMny) {
        this.baseMedicalPersonMny = baseMedicalPersonMny;
    }
    public BigDecimal getBaseMedicalCompanyPercent() {
        return baseMedicalCompanyPercent;
    }

    public void setBaseMedicalCompanyPercent(BigDecimal baseMedicalCompanyPercent) {
        this.baseMedicalCompanyPercent = baseMedicalCompanyPercent;
    }
    public BigDecimal getBaseMedicalCompanyMny() {
        return baseMedicalCompanyMny;
    }

    public void setBaseMedicalCompanyMny(BigDecimal baseMedicalCompanyMny) {
        this.baseMedicalCompanyMny = baseMedicalCompanyMny;
    }
    public BigDecimal getSeriousMedicalCompanyPercent() {
        return seriousMedicalCompanyPercent;
    }

    public void setSeriousMedicalCompanyPercent(BigDecimal seriousMedicalCompanyPercent) {
        this.seriousMedicalCompanyPercent = seriousMedicalCompanyPercent;
    }
    public BigDecimal getSeriousMedicalCompanyMny() {
        return seriousMedicalCompanyMny;
    }

    public void setSeriousMedicalCompanyMny(BigDecimal seriousMedicalCompanyMny) {
        this.seriousMedicalCompanyMny = seriousMedicalCompanyMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
