package com.ejianc.business.project;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 项目基本信息管理-人员派遣实体
 * 
 * @author generator
 * 
 */
public class InSiteVO extends BaseVO {

    private static final long serialVersionUID = 1405652434542795650L;

    private String billCode; //编码
    private Long projectId; // 项目Id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目部Id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织Id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long onSiteEmployeeId; // 人员id
    private String onSiteEmployeeName; // 人员名称
    private String onSiteEmployeeCode; // 人员编码
    private String area; // 地区
    private Long onSitePostId; // 驻场岗位id
    private String onSitePostName; // 驻场岗位名称
    private BigDecimal dailyMny; // 金额(天)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始时间
    private Long employeeId; // 编制人员id
    private String employeeName; // 编制人员名称
    private Long engineeringType; // 工程类型
    private String engineeringTypeName; //工程类型名称

    private Long refBillId; //引用单据id

    public Long getRefBillId() {
        return refBillId;
    }

    public void setRefBillId(Long refBillId) {
        this.refBillId = refBillId;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getOnSiteEmployeeId() {
        return onSiteEmployeeId;
    }
    @ReferDeserialTransfer
    public void setOnSiteEmployeeId(Long onSiteEmployeeId) {
        this.onSiteEmployeeId = onSiteEmployeeId;
    }
    public String getOnSiteEmployeeName() {
        return onSiteEmployeeName;
    }

    public void setOnSiteEmployeeName(String onSiteEmployeeName) {
        this.onSiteEmployeeName = onSiteEmployeeName;
    }
    public String getOnSiteEmployeeCode() {
        return onSiteEmployeeCode;
    }

    public void setOnSiteEmployeeCode(String onSiteEmployeeCode) {
        this.onSiteEmployeeCode = onSiteEmployeeCode;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    @ReferSerialTransfer(referCode = "bfyj-onsite-post")
    public Long getOnSitePostId() {
        return onSitePostId;
    }
    @ReferDeserialTransfer
    public void setOnSitePostId(Long onSitePostId) {
        this.onSitePostId = onSitePostId;
    }

    public String getOnSitePostName() {
        return onSitePostName;
    }

    public void setOnSitePostName(String onSitePostName) {
        this.onSitePostName = onSitePostName;
    }

    public BigDecimal getDailyMny() {
        return dailyMny;
    }

    public void setDailyMny(BigDecimal dailyMny) {
        this.dailyMny = dailyMny;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
