package com.ejianc.business.tax.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 税务管理-开票登记
 * 
 * @author generator
 * 
 */
public class InvoiceOpenRegistVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 开票登记单号
    private String applyCode; // 申请单号
    private Long applyId; // 申请单id
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 项目所属组织
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Long projectBillId; // 项目对账单id
    private Long buyerId; // 购方id（客户档案）
    private String buyerName; // 购方名称
    private Long projectAccountingId; // 项目会计
    private String projectAccountingName; // 项目会计名称
    private BigDecimal taxLevyRate; // 征收方式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualOpenDate; // 实际开票日期
    private BigDecimal openMny; // 开票额
    private BigDecimal shouldReceiveTax; // 应收税额
    private BigDecimal preparementMny; // 项目自己预缴
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date preparementDate; // 预缴属期
    private BigDecimal waitTaxMny; // 待收税款
    private Long contractualModel; // 承包模式
    private String contractualModelName; // 承包模式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申报日期
    private BigDecimal applyMny; // 申报金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dedDate; // 扣除日期
    private BigDecimal dedMny; // 扣除金额
    private Long supplierId; // 分包单位
    private String supplierName; // 分包单位名称
    private BigDecimal vatMny; // 项目自己增值税
    private String memo; // 备注
    private Integer flag; // 0-未被引用 1-被引用
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }
    @ReferSerialTransfer(referCode="bfyj-tax-open-apply")
    public Long getApplyId() {
        return applyId;
    }
    @ReferDeserialTransfer
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    @ReferSerialTransfer(referCode="bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectBillId() {
        return projectBillId;
    }

    public void setProjectBillId(Long projectBillId) {
        this.projectBillId = projectBillId;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getBuyerId() {
        return buyerId;
    }
    @ReferDeserialTransfer
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectAccountingId() {
        return projectAccountingId;
    }
    @ReferDeserialTransfer
    public void setProjectAccountingId(Long projectAccountingId) {
        this.projectAccountingId = projectAccountingId;
    }
    public String getProjectAccountingName() {
        return projectAccountingName;
    }

    public void setProjectAccountingName(String projectAccountingName) {
        this.projectAccountingName = projectAccountingName;
    }
    public BigDecimal getTaxLevyRate() {
        return taxLevyRate;
    }

    public void setTaxLevyRate(BigDecimal taxLevyRate) {
        this.taxLevyRate = taxLevyRate;
    }
    public Date getActualOpenDate() {
        return actualOpenDate;
    }

    public void setActualOpenDate(Date actualOpenDate) {
        this.actualOpenDate = actualOpenDate;
    }
    public BigDecimal getOpenMny() {
        return openMny;
    }

    public void setOpenMny(BigDecimal openMny) {
        this.openMny = openMny;
    }
    public BigDecimal getShouldReceiveTax() {
        return shouldReceiveTax;
    }

    public void setShouldReceiveTax(BigDecimal shouldReceiveTax) {
        this.shouldReceiveTax = shouldReceiveTax;
    }
    public BigDecimal getPreparementMny() {
        return preparementMny;
    }

    public void setPreparementMny(BigDecimal preparementMny) {
        this.preparementMny = preparementMny;
    }
    public Date getPreparementDate() {
        return preparementDate;
    }

    public void setPreparementDate(Date preparementDate) {
        this.preparementDate = preparementDate;
    }
    public BigDecimal getWaitTaxMny() {
        return waitTaxMny;
    }

    public void setWaitTaxMny(BigDecimal waitTaxMny) {
        this.waitTaxMny = waitTaxMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }
    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Date getDedDate() {
        return dedDate;
    }

    public void setDedDate(Date dedDate) {
        this.dedDate = dedDate;
    }
    public BigDecimal getDedMny() {
        return dedMny;
    }

    public void setDedMny(BigDecimal dedMny) {
        this.dedMny = dedMny;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getVatMny() {
        return vatMny;
    }

    public void setVatMny(BigDecimal vatMny) {
        this.vatMny = vatMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }
}
