package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 人力行政-薪资异动审批表
 * 
 * @author generator
 * 
 */
public class EmployeeSalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编号
    private Long employeeId; // 员工名称
    private String name; // 员工名称
    private Long orgId; // 区域ID
    private String orgName; // 区域
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 岗位ID
    private String postName; // 岗位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date useDate; // 生效日期
    private Integer rank; // 层级
    private String rankName; // 层级
    private Integer changeType; // 异动类别（1涨薪2降薪）
    private String changeTypeName; // 异动类别
    private BigDecimal changeSalary; // 异动金额
    private BigDecimal salary; // 薪资标准
    private BigDecimal basicSalary; // 原基本薪资
    private BigDecimal postSalary; // 原岗位薪资
    private BigDecimal levelSalary; // 原层级薪资
    private BigDecimal certSalary; // 证书津贴
    private BigDecimal educatedSalary; // 学历津贴
    private BigDecimal sportSalary; // 交通补助
    private BigDecimal yearSalary; // 司龄津贴
    private BigDecimal newSalary; // 异动后薪资标准
    private BigDecimal newBasicSalary; // 新基本薪资
    private BigDecimal newPostSalary; // 新岗位薪资
    private BigDecimal newLevelSalary; // 新层级薪资
    private String memo; // 异动原因
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="bfyj-employee-info")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getUseDate() {
        return useDate;
    }

    public void setUseDate(Date useDate) {
        this.useDate = useDate;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public String getChangeTypeName() {
        return changeTypeName;
    }

    public void setChangeTypeName(String changeTypeName) {
        this.changeTypeName = changeTypeName;
    }
    public BigDecimal getChangeSalary() {
        return changeSalary;
    }

    public void setChangeSalary(BigDecimal changeSalary) {
        this.changeSalary = changeSalary;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public BigDecimal getCertSalary() {
        return certSalary;
    }

    public void setCertSalary(BigDecimal certSalary) {
        this.certSalary = certSalary;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public BigDecimal getSportSalary() {
        return sportSalary;
    }

    public void setSportSalary(BigDecimal sportSalary) {
        this.sportSalary = sportSalary;
    }
    public BigDecimal getYearSalary() {
        return yearSalary;
    }

    public void setYearSalary(BigDecimal yearSalary) {
        this.yearSalary = yearSalary;
    }
    public BigDecimal getNewSalary() {
        return newSalary;
    }

    public void setNewSalary(BigDecimal newSalary) {
        this.newSalary = newSalary;
    }
    public BigDecimal getNewBasicSalary() {
        return newBasicSalary;
    }

    public void setNewBasicSalary(BigDecimal newBasicSalary) {
        this.newBasicSalary = newBasicSalary;
    }
    public BigDecimal getNewPostSalary() {
        return newPostSalary;
    }

    public void setNewPostSalary(BigDecimal newPostSalary) {
        this.newPostSalary = newPostSalary;
    }
    public BigDecimal getNewLevelSalary() {
        return newLevelSalary;
    }

    public void setNewLevelSalary(BigDecimal newLevelSalary) {
        this.newLevelSalary = newLevelSalary;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
