package com.ejianc.business.tax.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 税务管理-预缴完税登记
 * 
 * @author generator
 * 
 */
public class PrepaymentPaidVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编码
    private Long certId; // 外管证
    private String certName; // 外管证名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 项目所属组织
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillingDate; // 填发日期
    private String crossCode; // 跨区域编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billingDate; // 开票日期
    private BigDecimal billingMny; // 开票金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date prepaymentDate; // 预缴属期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taxDate; // 纳税日期
    private String overTaxCode; // 完税凭证号码
    private Long accountId; // 预缴账户
    private String accountName; // 预缴账户名称
    private BigDecimal prepaymentMny; // 预缴小计
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<PrepaymentPaidDetailVO> prepaymentPaidDetailList = new ArrayList<>(); // 税务管理-预缴完税登记-税务明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-out-cert")
    public Long getCertId() {
        return certId;
    }
    @ReferDeserialTransfer
    public void setCertId(Long certId) {
        this.certId = certId;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getFillingDate() {
        return fillingDate;
    }

    public void setFillingDate(Date fillingDate) {
        this.fillingDate = fillingDate;
    }
    public String getCrossCode() {
        return crossCode;
    }

    public void setCrossCode(String crossCode) {
        this.crossCode = crossCode;
    }
    public Date getBillingDate() {
        return billingDate;
    }

    public void setBillingDate(Date billingDate) {
        this.billingDate = billingDate;
    }
    public BigDecimal getBillingMny() {
        return billingMny;
    }

    public void setBillingMny(BigDecimal billingMny) {
        this.billingMny = billingMny;
    }
    public Date getPrepaymentDate() {
        return prepaymentDate;
    }

    public void setPrepaymentDate(Date prepaymentDate) {
        this.prepaymentDate = prepaymentDate;
    }
    public Date getTaxDate() {
        return taxDate;
    }

    public void setTaxDate(Date taxDate) {
        this.taxDate = taxDate;
    }
    public String getOverTaxCode() {
        return overTaxCode;
    }

    public void setOverTaxCode(String overTaxCode) {
        this.overTaxCode = overTaxCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-account-register")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public BigDecimal getPrepaymentMny() {
        return prepaymentMny;
    }

    public void setPrepaymentMny(BigDecimal prepaymentMny) {
        this.prepaymentMny = prepaymentMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<PrepaymentPaidDetailVO> getPrepaymentPaidDetailList() {
        return prepaymentPaidDetailList;
    }

    public void setPrepaymentPaidDetailList(List<PrepaymentPaidDetailVO> prepaymentPaidDetailList) {
        this.prepaymentPaidDetailList = prepaymentPaidDetailList;
    }
}
