package com.ejianc.business.oa.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 人力行政-员工转正审批表
 * 
 * @author generator
 * 
 */
public class EmployeeFormalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 员工编号
    private Long employeeId; // 员工名称
    private String name; // 员工名称
    private Long orgId; // 区域ID
    private String orgName; // 区域
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 岗位ID
    private String postName; // 岗位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date formalDate; // 转正日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDateBegin; // 试用日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDateEnd; // 试用日期
    private Integer contractTerm; // 合同年限
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateBegin; // 合同时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateEnd; // 合同时间
    private Integer rank; // 职级
    private String rankName; // 职级
    private BigDecimal salary; // 薪资标准
    private BigDecimal basicSalary; // 基本薪资
    private BigDecimal postSalary; // 岗位薪资
    private BigDecimal levelSalary; // 层级薪资
    private Integer insuredFlag; // 是否缴纳保险
    private String insuredFlagName; // 是否缴纳保险
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredDate; // 缴纳时间
    private String insuredType; // 保险种类
    private String insuredTypeName; // 保险种类
    private String cert; // 证书情况
    private String certName; // 证书情况
    private BigDecimal educatedSalary; // 学历津贴
    private BigDecimal sportSalary; // 交通补助
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 发放起止时间
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long yearSalaryId; // 司龄津贴
    private BigDecimal yearSalary; // 司龄津贴
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date yearChangeDate; // 司龄调整月份
    private BigDecimal certSalary; // 证书津贴

    public BigDecimal getCertSalary() {
        return certSalary;
    }

    public void setCertSalary(BigDecimal certSalary) {
        this.certSalary = certSalary;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="bfyj-employee-info")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getFormalDate() {
        return formalDate;
    }

    public void setFormalDate(Date formalDate) {
        this.formalDate = formalDate;
    }

    public Date getTryDateBegin() {
        return tryDateBegin;
    }

    public void setTryDateBegin(Date tryDateBegin) {
        this.tryDateBegin = tryDateBegin;
    }

    public Date getTryDateEnd() {
        return tryDateEnd;
    }

    public void setTryDateEnd(Date tryDateEnd) {
        this.tryDateEnd = tryDateEnd;
    }


    public Integer getContractTerm() {
        return contractTerm;
    }

    public void setContractTerm(Integer contractTerm) {
        this.contractTerm = contractTerm;
    }

    public Date getContractDateBegin() {
        return contractDateBegin;
    }

    public void setContractDateBegin(Date contractDateBegin) {
        this.contractDateBegin = contractDateBegin;
    }

    public Date getContractDateEnd() {
        return contractDateEnd;
    }

    public void setContractDateEnd(Date contractDateEnd) {
        this.contractDateEnd = contractDateEnd;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public Date getInsuredDate() {
        return insuredDate;
    }

    public void setInsuredDate(Date insuredDate) {
        this.insuredDate = insuredDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getInsuredType() {
        return insuredType;
    }
    @ReferDeserialTransfer
    public void setInsuredType(String insuredType) {
        this.insuredType = insuredType;
    }
    public String getInsuredTypeName() {
        return insuredTypeName;
    }

    public void setInsuredTypeName(String insuredTypeName) {
        this.insuredTypeName = insuredTypeName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getCert() {
        return cert;
    }
    @ReferDeserialTransfer
    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public BigDecimal getSportSalary() {
        return sportSalary;
    }

    public void setSportSalary(BigDecimal sportSalary) {
        this.sportSalary = sportSalary;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="bfyj-year-salary")
    public Long getYearSalaryId() {
        return yearSalaryId;
    }
    @ReferDeserialTransfer
    public void setYearSalaryId(Long yearSalaryId) {
        this.yearSalaryId = yearSalaryId;
    }
    public BigDecimal getYearSalary() {
        return yearSalary;
    }

    public void setYearSalary(BigDecimal yearSalary) {
        this.yearSalary = yearSalary;
    }
    public Date getYearChangeDate() {
        return yearChangeDate;
    }

    public void setYearChangeDate(Date yearChangeDate) {
        this.yearChangeDate = yearChangeDate;
    }
    
}
