package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 投标管理-商机登记实体
 * 
 * @author generator
 * 
 */
public class BusOpportunityVO extends BaseVO {

    private static final long serialVersionUID = 5618537901736039373L;
    private Long registrationId; // 项目报名表Id
    private String billCode; // 编码
    private String engineeringName; // 工程名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registrationDate; // 报名日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registrationEndDate; // 报名截止日期
    private Long provinceId; // 省份id
    private String provinceCode; // 省份编码
    private String provinceName; // 省份名称
    private Long cityId; // 地级市id
    private String cityCode; // 地级市编码
    private String cityName; // 地级市名称
    private Long regionId; // 项目所属大区id
    private String regionCode; // 项目所属大区编码
    private String regionName; // 项目所属大区名称
    private String regionCharacter; // 项目所属大区性质
    private String tableName; // 表名
    private Long qualificationUnitId; // 资质单位id
    private String qualificationUnitCode; // 资质单位编码
    private String qualificationUnitName; // 资质单位名称
    private Long qualificationTypeId; // 资质类别id
    private String qualificationTypeCode; // 资质单位编码
    private String qualificationTypeName; // 资质类别名称
    private Long qualificationLevelId; // 资质等级id
    private String qualificationLevelCode; // 资质等级编码
    private String qualificationLevelName; // 资质等级名称
    private String managerMajorId; // 项目经理专业id
    private String managerMajorCode; // 项目经理专业编码
    private String managerMajorName; // 项目经理专业名称
    private Long managerLevelId; // 项目经理级别id
    private String managerLevelCode; // 项目经理级别编码
    private String managerLevelName; // 项目经理级别名称
    private Long techLevelId; // 技术负责人级别id
    private String techLevelCode; // 技术负责人级别编码
    private String techLevelName; // 技术负责人级别名称
    private BigDecimal biddingFee; // 标书费用
    private BigDecimal qualificationFee; // 资质费用
    private Integer isBidWinning; // 是否中标：0-否，1-是
    private String projectPeriod; // 工期
    private BigDecimal biddingControlMmy; // 控制价(万元)
    private Long followPersonId; // 业务经理id
    private String followPerson; // 业务经理
    private Long documenterId; // 资料员id
    private String documenterName; // 资料员名称
    private Integer makeTenderFlag; // 是否制作标书：0-否，1-是
    private Long netAuthPersonId; // 授权人(网开)id
    private String netAuthPersonName; // 授权人(网开)名称
    private Long siteAuthPersonId; // 授权人(现场)id
    private String siteAuthPersonName; // 授权人(现场)名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date openTenderDate; // 开标时间
    private String remittanceName; // 汇款姓名
    private BigDecimal remittanceMmy; // 汇款金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date remittanceDate; // 汇款日期
    private String tenderLink; // 招标公告链接
    private String businessState; // 状态
    private String memo; // 备注
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期

    private String pubUnitName; //发包单位

    private Long orgId; // 所属组织Id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称

    private Integer orgType; //所属组织类型 报表使用字段

    private String reportQuoteFlag; //费用提成报表引用标识：0-未引用，1-已引用

    public Integer getOrgType() {
        return orgType;
    }

    public void setOrgType(Integer orgType) {
        this.orgType = orgType;
    }

    public String getReportQuoteFlag() {
        return reportQuoteFlag;
    }

    public void setReportQuoteFlag(String reportQuoteFlag) {
        this.reportQuoteFlag = reportQuoteFlag;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getQualificationUnitId() {
        return qualificationUnitId;
    }

    @ReferDeserialTransfer
    public void setQualificationUnitId(Long qualificationUnitId) {
        this.qualificationUnitId = qualificationUnitId;
    }

    public String getQualificationUnitCode() {
        return qualificationUnitCode;
    }

    public void setQualificationUnitCode(String qualificationUnitCode) {
        this.qualificationUnitCode = qualificationUnitCode;
    }

    public String getQualificationUnitName() {
        return qualificationUnitName;
    }

    public void setQualificationUnitName(String qualificationUnitName) {
        this.qualificationUnitName = qualificationUnitName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getQualificationTypeId() {
        return qualificationTypeId;
    }

    @ReferDeserialTransfer
    public void setQualificationTypeId(Long qualificationTypeId) {
        this.qualificationTypeId = qualificationTypeId;
    }

    public String getQualificationTypeCode() {
        return qualificationTypeCode;
    }

    public void setQualificationTypeCode(String qualificationTypeCode) {
        this.qualificationTypeCode = qualificationTypeCode;
    }

    public String getQualificationTypeName() {
        return qualificationTypeName;
    }

    public void setQualificationTypeName(String qualificationTypeName) {
        this.qualificationTypeName = qualificationTypeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getQualificationLevelId() {
        return qualificationLevelId;
    }

    @ReferDeserialTransfer
    public void setQualificationLevelId(Long qualificationLevelId) {
        this.qualificationLevelId = qualificationLevelId;
    }


    public String getQualificationLevelCode() {
        return qualificationLevelCode;
    }

    public void setQualificationLevelCode(String qualificationLevelCode) {
        this.qualificationLevelCode = qualificationLevelCode;
    }

    public String getQualificationLevelName() {
        return qualificationLevelName;
    }

    public void setQualificationLevelName(String qualificationLevelName) {
        this.qualificationLevelName = qualificationLevelName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getNetAuthPersonId() {
        return netAuthPersonId;
    }
    @ReferDeserialTransfer
    public void setNetAuthPersonId(Long netAuthPersonId) {
        this.netAuthPersonId = netAuthPersonId;
    }

    public String getNetAuthPersonName() {
        return netAuthPersonName;
    }

    public void setNetAuthPersonName(String netAuthPersonName) {
        this.netAuthPersonName = netAuthPersonName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSiteAuthPersonId() {
        return siteAuthPersonId;
    }
    @ReferDeserialTransfer
    public void setSiteAuthPersonId(Long siteAuthPersonId) {
        this.siteAuthPersonId = siteAuthPersonId;
    }

    public String getSiteAuthPersonName() {
        return siteAuthPersonName;
    }

    public void setSiteAuthPersonName(String siteAuthPersonName) {
        this.siteAuthPersonName = siteAuthPersonName;
    }

    @ReferSerialTransfer(referCode = "bfyj-bid-projectRegistration")
    public Long getRegistrationId() {
        return registrationId;
    }

    @ReferDeserialTransfer
    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public Date getRegistrationDate() {
        return registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }
    public Date getRegistrationEndDate() {
        return registrationEndDate;
    }

    public void setRegistrationEndDate(Date registrationEndDate) {
        this.registrationEndDate = registrationEndDate;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-area")
    public Long getProvinceId() {
        return provinceId;
    }
    @ReferDeserialTransfer
    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }
    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }
    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-area")
    public Long getCityId() {
        return cityId;
    }
    @ReferDeserialTransfer
    public void setCityId(Long cityId) {
        this.cityId = cityId;
    }
    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }
    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getRegionId() {
        return regionId;
    }
    @ReferDeserialTransfer
    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }
    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }
    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }
    public String getRegionCharacter() {
        return regionCharacter;
    }

    public void setRegionCharacter(String regionCharacter) {
        this.regionCharacter = regionCharacter;
    }
    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getManagerMajorId() {
        return managerMajorId;
    }
    @ReferDeserialTransfer
    public void setManagerMajorId(String managerMajorId) {
        this.managerMajorId = managerMajorId;
    }

    public String getManagerMajorCode() {
        return managerMajorCode;
    }

    public void setManagerMajorCode(String managerMajorCode) {
        this.managerMajorCode = managerMajorCode;
    }
    public String getManagerMajorName() {
        return managerMajorName;
    }

    public void setManagerMajorName(String managerMajorName) {
        this.managerMajorName = managerMajorName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getManagerLevelId() {
        return managerLevelId;
    }
    @ReferDeserialTransfer
    public void setManagerLevelId(Long managerLevelId) {
        this.managerLevelId = managerLevelId;
    }
    public String getManagerLevelCode() {
        return managerLevelCode;
    }

    public void setManagerLevelCode(String managerLevelCode) {
        this.managerLevelCode = managerLevelCode;
    }
    public String getManagerLevelName() {
        return managerLevelName;
    }

    public void setManagerLevelName(String managerLevelName) {
        this.managerLevelName = managerLevelName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getTechLevelId() {
        return techLevelId;
    }
    @ReferDeserialTransfer
    public void setTechLevelId(Long techLevelId) {
        this.techLevelId = techLevelId;
    }
    public String getTechLevelCode() {
        return techLevelCode;
    }

    public void setTechLevelCode(String techLevelCode) {
        this.techLevelCode = techLevelCode;
    }
    public String getTechLevelName() {
        return techLevelName;
    }

    public void setTechLevelName(String techLevelName) {
        this.techLevelName = techLevelName;
    }
    public BigDecimal getBiddingFee() {
        return biddingFee;
    }

    public void setBiddingFee(BigDecimal biddingFee) {
        this.biddingFee = biddingFee;
    }
    public BigDecimal getQualificationFee() {
        return qualificationFee;
    }

    public void setQualificationFee(BigDecimal qualificationFee) {
        this.qualificationFee = qualificationFee;
    }
    public Integer getIsBidWinning() {
        return isBidWinning;
    }

    public void setIsBidWinning(Integer isBidWinning) {
        this.isBidWinning = isBidWinning;
    }
    public String getProjectPeriod() {
        return projectPeriod;
    }

    public void setProjectPeriod(String projectPeriod) {
        this.projectPeriod = projectPeriod;
    }
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFollowPersonId() {
        return followPersonId;
    }
    @ReferDeserialTransfer
    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDocumenterId() {
        return documenterId;
    }

    @ReferDeserialTransfer
    public void setDocumenterId(Long documenterId) {
        this.documenterId = documenterId;
    }
    public String getDocumenterName() {
        return documenterName;
    }

    public void setDocumenterName(String documenterName) {
        this.documenterName = documenterName;
    }
    public Integer getMakeTenderFlag() {
        return makeTenderFlag;
    }

    public void setMakeTenderFlag(Integer makeTenderFlag) {
        this.makeTenderFlag = makeTenderFlag;
    }
    public Date getOpenTenderDate() {
        return openTenderDate;
    }

    public void setOpenTenderDate(Date openTenderDate) {
        this.openTenderDate = openTenderDate;
    }
    public String getRemittanceName() {
        return remittanceName;
    }

    public void setRemittanceName(String remittanceName) {
        this.remittanceName = remittanceName;
    }
    public BigDecimal getRemittanceMmy() {
        return remittanceMmy;
    }

    public void setRemittanceMmy(BigDecimal remittanceMmy) {
        this.remittanceMmy = remittanceMmy;
    }
    public Date getRemittanceDate() {
        return remittanceDate;
    }

    public void setRemittanceDate(Date remittanceDate) {
        this.remittanceDate = remittanceDate;
    }
    public String getTenderLink() {
        return tenderLink;
    }

    public void setTenderLink(String tenderLink) {
        this.tenderLink = tenderLink;
    }
    public String getBusinessState() {
        return businessState;
    }

    public void setBusinessState(String businessState) {
        this.businessState = businessState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
