package com.ejianc.business.project;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目基本信息管理-项目立项
 * 
 * @author generator
 * 
 */
public class ProjectRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 项目编号
    private String name; // 项目名称
    private String shortName; //项目简称
    private Long registrationId; // 项目报名表Id
    private Long opportunityId; // 商机登记表Id
    private Long opportunityBillCode; // 商机登记单据编码
    private Long affirmId; // 项目登记确认单Id
    private String affirmBillCode; // 项目登记确认单编码
    private Long orgId; // 所属组织Id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称
    private String status; // 项目状态：1-未开工, 2-在建，3-完成
    private String validStatus; // 项目停用状态：0-启用，1-停用
    private String type; // 项目类型：1-自营，2-联营
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registDate; // 立项日期
    private Long contractualModel; // 承包模式
    private String contractualModelName; // 承包模式名称
    private Long pubUnit; // 发包单位
    private String pubUnitName;//发包单位名称
    private Long contractorUnit; // 承包单位
    private String contractorUnitName;//承包单位名称
    private Long provinceId; // 所属省份Id
    private Long engineeringType; // 工程类型
    private String engineeringTypeName; //工程类型名称
    private Long infoSource; // 信息来源
    private String infoSourceName;//信息来源名称
    private String address; // 详细地址
    private Long investor; // 投资主体
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bidDate; // 中标日期
    private BigDecimal bidMny; // 中标金额(元)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date plannedCommencementDate; // 计划开工日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date plannedFinishDate; // 计划竣工日期
    private BigDecimal duration; // 计划工期
    private String collectionTypeName; // 征收方式及标准
    private String otherFee; // 其他收费项
    private Long structureType; // 结构类型
    private String structureTypeName;//结构类型名称
    private Long engineeringPurpose; // 工程用途
    private String engineeringPurposeName;// 工程用途名称
    private Long projectManager; // 项目经理
    private Long techManager; // 技术负责人/总工
    private Long followPersonId; // 业务经理
    private Long projectAccountingId; // 项目会计
    private Integer pubFlag; // 是否公示：0-否，1-是
    private String belongPersonName; // 项目所属人
    private BigDecimal taxLevyRate; // 税金征收率
    private BigDecimal managementFeeRate; // 管理费征收率
    private BigDecimal noCostTicketReservedLevyRate; // 无成本票预留征收率
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期

    private Long projectDepartmentId; //所属项目部Id
    private String projectDepartmentCode; //所属项目部编码
    private String projectDepartmentName; //所属项目部名称
    
    private List<ProjectRegisterFileVO> detailList = new ArrayList<>(); // 项目基本信息管理-项目资料子实体

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    @ReferDeserialTransfer
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentCode() {
        return projectDepartmentCode;
    }

    public void setProjectDepartmentCode(String projectDepartmentCode) {
        this.projectDepartmentCode = projectDepartmentCode;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }

    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getRegistrationId() {
        return registrationId;
    }


    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-busOpportunity")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    @ReferSerialTransfer(referCode = "byfj-bid-projectRegistrationAffirm")
    public Long getAffirmId() {
        return affirmId;
    }
    @ReferDeserialTransfer
    public void setAffirmId(Long affirmId) {
        this.affirmId = affirmId;
    }
    public String getAffirmCode() {
        return affirmBillCode;
    }

    public void setAffirmCode(String affirmCode) {
        this.affirmBillCode = affirmBillCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }
    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    @ReferSerialTransfer(referCode = "support-customer")
    public Long getPubUnit() {
        return pubUnit;
    }
    @ReferDeserialTransfer
    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getContractorUnit() {
        return contractorUnit;
    }
    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProvinceId() {
        return provinceId;
    }
    @ReferDeserialTransfer
    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInfoSource() {
        return infoSource;
    }
    @ReferDeserialTransfer
    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getInvestor() {
        return investor;
    }
    @ReferDeserialTransfer
    public void setInvestor(Long investor) {
        this.investor = investor;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }
    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }
    public BigDecimal getDuration() {
        return duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }
    public String getCollectionTypeName() {
        return collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }
    public String getOtherFee() {
        return otherFee;
    }

    public void setOtherFee(String otherFee) {
        this.otherFee = otherFee;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getStructureType() {
        return structureType;
    }
    @ReferDeserialTransfer
    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }
    @ReferDeserialTransfer
    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }
    @ReferSerialTransfer(referCode = "cert-record")
    public Long getProjectManager() {
        return projectManager;
    }
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    @ReferSerialTransfer(referCode = "cert-record")
    public Long getTechManager() {
        return techManager;
    }
    @ReferDeserialTransfer
    public void setTechManager(Long techManager) {
        this.techManager = techManager;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFollowPersonId() {
        return followPersonId;
    }
    @ReferDeserialTransfer
    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectAccountingId() {
        return projectAccountingId;
    }
    @ReferDeserialTransfer
    public void setProjectAccountingId(Long projectAccountingId) {
        this.projectAccountingId = projectAccountingId;
    }
    public Integer getPubFlag() {
        return pubFlag;
    }

    public void setPubFlag(Integer pubFlag) {
        this.pubFlag = pubFlag;
    }
    public String getBelongPersonName() {
        return belongPersonName;
    }

    public void setBelongPersonName(String belongPersonName) {
        this.belongPersonName = belongPersonName;
    }
    public BigDecimal getTaxLevyRate() {
        return taxLevyRate;
    }

    public void setTaxLevyRate(BigDecimal taxLevyRate) {
        this.taxLevyRate = taxLevyRate;
    }
    public BigDecimal getManagementFeeRate() {
        return managementFeeRate;
    }

    public void setManagementFeeRate(BigDecimal managementFeeRate) {
        this.managementFeeRate = managementFeeRate;
    }
    public BigDecimal getNoCostTicketReservedLevyRate() {
        return noCostTicketReservedLevyRate;
    }

    public void setNoCostTicketReservedLevyRate(BigDecimal noCostTicketReservedLevyRate) {
        this.noCostTicketReservedLevyRate = noCostTicketReservedLevyRate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }


    public List<ProjectRegisterFileVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ProjectRegisterFileVO> detailList) {
        this.detailList = detailList;
    }
}
